package game;


import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Transparency;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PonyPanel extends JPanel implements Runnable {
	
	private Thread theGame;
	
	public static final int PLAY_AREA_WIDTH = 800;
	public static final int PANEL_HEIGHT = 488;
	
	public static final int NORMAL_PLAYER_STEP = 10;
	public static final int FAST_PLAYER_STEP = 20;
	                                           
	public static final long TICK_LENGTH_NANO = 50000000L;
	//33333333L = 30 FPS
	//66666666L = 15 FPS
	//50000000L = 20 FPS
	//40000000L = 25 FPS
    //100000000L = 10 FPS
	
	private boolean alreadyDidPink3;
	private boolean alreadyDidPink4;
	
	private Graphics2D canvasGraphics;
	private BufferedImage canvasBuffer;
	private BufferedImage canvasBufferTwo;
	private boolean usingBufferTwo;
	
	private Graphics scoreboardGraphics;
	private Image scoreboardBuffer;
	
	private Graphics titleScreenGraphics;
	private Image titleScreenBuffer;
	
	private boolean playerIsGoingUp = false;
	private boolean playerIsGoingDown = false;
	private boolean playerIsGoingLeft = false;
	private boolean playerIsGoingRight = false;
	
	private boolean playerIsFiring = false;
	private boolean playerIsInteracting = false;
	private boolean isBombing = false;
	private boolean isNetting = false;
	
	private boolean shouldNotExit = false;
	private boolean isPaused = false;
	private boolean gameRunning = false;
	
	private boolean wasGameEverStarted = false;
	
	private int totalTicksOfGameplay;
	
	private boolean foregroundIsPrimed = false;
	private long lastBulletFireTimestamp = Long.MIN_VALUE;
	
	private PlayerSprite player;
	private ForegroundImage currentForeground;
	
	
	private Container enclosing;
	
//	private AudioManager audioManager;
	
	private String nameOfSnagFile = null;
	
//	private CustomImageDataII backgroundImages[] = null;
//	private int backgroundCurrentImage = 0;
//	
//	private CustomImageDataII titleImages[] = null;
//	private int titleCurrentImage = 0;
//	
//	private CustomImageDataII badEndImages[] = null;
//	private int badEndCurrentImage = 0;
//	
//	private CustomImageDataII normalEndImages[] = null;
//	private int normalEndCurrentImage = 0;
//	
//	private CustomImageDataII goodEndImages[] = null;
//	private int goodEndCurrentImage = 0;
//	
//	private CustomImageDataII overlayImages[] = null;
//	private int overlayCurrentImage = 0;
	
	
	private int upKey;
	private int downKey;
	private int leftKey;
	private int rightKey;
	private int snagKey;
	private int bombKey;
	private int netKey;
	private int newGameKey;
	private int pauseKey;
	private int exitKey;
	
	private String helpText = null;
	private JFrame helpFrame = null;
	
	private boolean hasImagesLoaded = false;
	
	private boolean loadMethodWantsPause = false;
	private boolean loadMethodMayHavePause = false;
	
	private PipedInputStream waitMechanismIn = null;
	private PipedOutputStream waitMechanismOut = null;
	
	private int startingLevel = 1;
	
	private ArrayList<SolidBlockSprite> blocks = null;
	
	private StaticBlockManager blockManager = null;
	
	private ArrayList<EnemySprite> enemies = null;
	
	private long startPrimingTime;
	
	private ArrayList<BulletSprite> bullets = null;
	
	private ArrayList<BulletSprite> enemyBullets = null;
	
	private ArrayList<FadingEnemySprite> fadingEnemies = null;
	
	private ArrayList<ItemSprite> items = null;
	
	private RoomData currentRoom = null;
	
	private BulletImageManager bulletImageManager = null;
	
	private Color backgroundColor = null;
	
	private ArrayList<DoorSprite> doors = null;
	
	private ArrayList<DoorSprite> commentDoors = null;
	
	private LevelData dummyLevel = null;
	
	private ItemImageManager itemImageManager = null;
	
	private ArrayList<RadioSprite> radios = null;
	
	
	private int playerRespawnX;
	private int playerRespawnY;
	private RoomData playerRespawnRoom;
	private String roomWhereBossWasKilled;
	
	private int deathSegueTicks = 0;
	private int doorSegueTicks = 0;
	private int deathUnfadeTicks = 0;
	private int doorUnfadeTicks = 0;
	private Image stopFrame = null;
	private RoomData roomToBeLoaded = null;
	private int roomToBeLoadedPlayerX = Integer.MIN_VALUE;
	private int roomToBeLoadedPlayerY = Integer.MIN_VALUE;
	
	public static final int SEGUE_FRAMES = 30;
	
	private RainbowElementalSprite bossSprite = null;
	
	private EnemyImageManager enemyImageManager = null;
	
	private ArrayList<WidgetSprite> backgroundWidgets;
	private ArrayList<WidgetSprite> commentWidgets;
	private ArrayList<WidgetSprite> foregroundWidgets;
	
	private CustomImageDataII menuImage = null;
//	private CustomImageDataII beatenMenuImage = null;
	private CustomImageDataII menuImageNoResume = null;
//	private CustomImageDataII beatenMenuImageNoResume = null;
	private CustomImageDataII confirmExitMenuImage = null;
	private CustomImageDataII saveOrExitMenuImage = null;
	private CustomImageDataII confirmNewMenuImage = null;
	private CustomImageDataII aboutImage = null;
	private CustomImageDataII storyImage = null;
	private CustomImageDataII adventureLoadTutorialMenuImage = null;
	private CustomImageDataII quickKeyReferenceImage = null;
	
	private CustomImageDataII optionsMenuLockedOffImage = null;
	private CustomImageDataII optionsMenuLockedOnImage = null;
	private CustomImageDataII optionsMenuMusicOnImage = null;
	private CustomImageDataII optionsMenuCommentaryOnImage = null;
	private CustomImageDataII optionsMenuBothOnImage = null;
	private CustomImageDataII optionsMenuBothOffImage = null;
	
	private CustomImageDataII commentaryEnabledImage = null;
	
	private int menuPosition = 2;
	
	public static final int MENU_POSITION_NEW = 1;
	public static final int MENU_POSITION_RESUME = 2;
	public static final int MENU_POSITION_STORY = 3;
	public static final int MENU_POSITION_KEYS = 18;
	public static final int MENU_POSITION_ABOUT = 4;
	public static final int MENU_POSITION_OPTIONS = 5;
	public static final int MENU_POSITION_EXIT = 6;
	public static final int MENU_POSITION_RESTORE = 23;
	
	public static final int MENU_POSITION_CONFIRM_NO = 7;
	public static final int MENU_POSITION_CONFIRM_YES = 8;
	
	
	public static final int MENU_POSITION_ADVENTURE = 9;
	public static final int MENU_POSITION_LOAD = 10;
	public static final int MENU_POSITION_TUTORIAL = 11;
	public static final int MENU_POSITION_NEW_CANCEL = 12;
	
	public static final int MENU_POSITION_MUSIC_ON = 13;
	public static final int MENU_POSITION_MUSIC_OFF = 14;
	public static final int MENU_POSITION_COMMENTARY_ON = 15;
	public static final int MENU_POSITION_COMMENTARY_OFF = 16;
	public static final int MENU_POSITION_OPTIONS_BACK = 17;
	
	public static final int MENU_POSITION_COMMENTARY_UNLOCKED_OK = 19;
	
	public static final int MENU_POSITION_EXITMENU_SAVE = 20;
	public static final int MENU_POSITION_EXITMENU_CANCEL = 21;
	public static final int MENU_POSITION_EXITMENU_EXIT = 22;
	
	public static final int MENU_POSITION_WANT_TO_HELP = 25;
	public static final int MENU_POSITION_LEAVE_FEEDBACK = 24;
	
	
	private boolean isShowingSaveExitMenu = false;
	private boolean isConfirmingNew = false;
	private boolean isConfirmingLoad = false;
	private boolean isConfirmingNewTutorial = false;
	private boolean isSelectingNew = false;
	private boolean isShowingQuickKeyReference = false;
	private boolean isShowingCommentaryUnlocked = false;
	
	private boolean canResume = true;
	private boolean commentaryIsNotLocked = false;
	private boolean isSelectingOptions = false;
	
	private boolean isShowingStory = false;
	private boolean isShowingAbout = false;
	
	private boolean musicSwitchedOn = true;
	private boolean commentarySwitchedOn = false;
	
	private static final int MAX_ENEMY_BULLETS = 8;
	
	private ArrayList<MarquisSprite> marquisSprites;
	
	private boolean isShowingEndingCutscene = false;
	
	private LevelData tutorialLevel;
	private LevelData mainLevel;
	

	private GoalSprite goalSprite;
	
	private RainSprite rain;
	
	private ArrayList<CustomNpc> customNpcs;
	
	private BackgroundMusic bgm;
	
	
	
	private ArrayList<HurtzoneSprite> hurtzones;
	
	
	private LevelData loadLevel;
	
	private boolean alreadyWroteIt = false;
	
	private CustomImageDataII loadingAnimation[];
	private int loadingFrame = 0;
	
	private boolean isLoading = false;
	private double loadProgress = 0.0;
	private String lastRoomLoaded = null;
	
	private boolean isFromFiles = false;
	
	private boolean roomIsntEvenLoaded = false;
	
	
	private BufferedImage createCanvasBuffer(int theWidth, int theHeight) {
		GraphicsConfiguration gc = CustomImageDataII.getGC();
		return gc.createCompatibleImage(theWidth, theHeight, Transparency.TRANSLUCENT);
	}
	
	private void gameDraw() {
//		//System.out.println("now in gameDraw");
		
		
		if(canvasBuffer == null) {
//			canvasBuffer = createImage(PLAY_AREA_WIDTH, PANEL_HEIGHT + 50);
			canvasBuffer = createCanvasBuffer(PLAY_AREA_WIDTH, PANEL_HEIGHT + 112);
			
		} else {
			canvasBuffer.flush();
		}
		
		if(canvasBuffer == null) {
//			System.err.println("<><>DELME ERROR:  canvasBuffer was null");
			return;
		} else {
//			canvasGraphics = canvasBuffer.getGraphics();
			canvasGraphics = canvasBuffer.createGraphics();
//			System.out.println("<><>DELME about to make some canvasGraphics...");
		}
		
		
		if(isLoading || roomIsntEvenLoaded) {
			
//			System.out.println("<><>DELME should be drawing the loading...");
			drawLoading(canvasGraphics);
			canvasGraphics.dispose();
			return;
			
		} else if(isShowingEndingCutscene && goalSprite != null && goalSprite.getEndCutsceneImage() != null) {
			
			CustomImageDataII endFrame = goalSprite.getEndCutsceneImage();
			
			endFrame.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
			
			drawMenuIfRelevant();
			
			canvasGraphics.dispose();
			
			return;
			
//		} else if (isShowingEndingCutscene && goalSprite != null && goalSprite.getEndCutsceneImage() == null) {
//			
////			//System.out.println("<><>DELME writing out the current frame");
//			if(!alreadyWroteIt)
//				writeOutForeground();
//			alreadyWroteIt = true;
			
		} else {
		
			if(stopFrame != null && (deathSegueTicks > 0 || doorSegueTicks > 0)) {
				canvasGraphics.drawImage(stopFrame, 0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT, null);
				
				Color origCol = canvasGraphics.getColor();
				
				if(deathSegueTicks > 0) {
					Color penColor = new Color(255,255,255, 255 * (SEGUE_FRAMES - deathSegueTicks) / SEGUE_FRAMES);
					canvasGraphics.setColor(penColor);
				} else {
					Color penColor = new Color(0,0,0, 255 * (SEGUE_FRAMES - doorSegueTicks) / SEGUE_FRAMES);
					canvasGraphics.setColor(penColor);
				}
				
				
				canvasGraphics.fillRect(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				
				canvasGraphics.setColor(origCol);
				
				drawMenuIfRelevant();
				
				canvasGraphics.dispose();
				return;
			}
			
			
			if(backgroundColor != null) {
				canvasGraphics.setColor(backgroundColor);
			} else {
				canvasGraphics.setColor(new Color(0, 255, 0));
			}
			
			canvasGraphics.fillRect(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT + 112);
			
			
			if(blockManager.getBackgroundBackground() != null) {
				canvasGraphics.drawImage(blockManager.getBackgroundBackground(), 0, 0, this);
	//			//System.err.println("<><>DELME                                                yes yes yes yes yes");
			} else {
	//			//System.err.println("<><>DELME                                                no no no no no no no");
			}
			
			if(startPrimingTime + 2000L > System.currentTimeMillis()) {
				primeAllImagesExceptTheForeground();
				
				canvasGraphics.setColor(Color.white);
				canvasGraphics.drawString("loading...", PLAY_AREA_WIDTH / 2, PANEL_HEIGHT / 2);
				
				canvasGraphics.dispose();
				
				return;
			} else if(startPrimingTime + 3000L > System.currentTimeMillis()) {
				primeForeground();
				canvasGraphics.setColor(Color.white);
				canvasGraphics.drawString("loading......", PLAY_AREA_WIDTH / 2, PANEL_HEIGHT / 2);
				
				canvasGraphics.dispose();
				
				return;
			}
			
			int roomHeight = blockManager.getTotalHeight();
			int roomWidth = blockManager.getTotalWidth();
			
			if(roomWidth > 0 && roomHeight > 0) {
				int bgTopRectMax = PANEL_HEIGHT / 2 - player.getyPos();
				int bgBottomRectMin = PANEL_HEIGHT / 2 + roomHeight - player.getyPos();
				
				if(backgroundColor == null) {
					canvasGraphics.setColor(new Color(128, 64, 0));
				} else {
					canvasGraphics.setColor(backgroundColor);
				}
				
				if(bgTopRectMax >= 0) {
					canvasGraphics.fillRect(0, 0, PLAY_AREA_WIDTH, bgTopRectMax);
				}
				
				if(bgBottomRectMin <= PANEL_HEIGHT) {
					canvasGraphics.fillRect(0, bgBottomRectMin, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
				
				int bgLeftRectMax = PLAY_AREA_WIDTH / 2 - player.getxPos();
				int bgRightRectMin = PLAY_AREA_WIDTH / 2 + roomWidth - player.getxPos();
				
				if(bgLeftRectMax >= 0) {
					canvasGraphics.fillRect(0, 0, bgLeftRectMax, PANEL_HEIGHT);
				}
				
				if(bgRightRectMin <= PLAY_AREA_WIDTH) {
					canvasGraphics.fillRect(bgRightRectMin, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
			}
			
			
			currentForeground.draw(canvasGraphics, player.getxPos(), player.getyPos(), PLAY_AREA_WIDTH, PANEL_HEIGHT);
	//		blockManager.drawTheHardWay(canvasGraphics, player);
			
	
			if(backgroundWidgets != null) {
				for(WidgetSprite w : backgroundWidgets) {
					w.draw(canvasGraphics, player.getxPos(), player.getyPos(), this.PLAY_AREA_WIDTH, this.PANEL_HEIGHT);
				}
			}
			
			for(DoorSprite door : doors) {
				door.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
			}
			
			if(commentarySwitchedOn) {
				if(commentWidgets != null) {
					for(WidgetSprite w : commentWidgets) {
						w.draw(canvasGraphics, player.getxPos(), player.getyPos(), this.PLAY_AREA_WIDTH, this.PANEL_HEIGHT);
					}
				}
				
				
				for(DoorSprite door : commentDoors) {
					door.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
				
				for(RadioSprite radio : radios) {
					radio.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
			}
			
			
			for(BlockInterface block : blocks) {
				block.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
			}
			
			for(int i = 0; i < marquisSprites.size(); i++){
				marquisSprites.get(i).draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
			}
			
			if(bossSprite != null)
				bossSprite.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
			
			if(goalSprite != null) {
				goalSprite.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
			}
			
			if(bullets != null) {
				BulletSprite b = null;
				for(int i = 0; i < bullets.size(); i++) {
					try {
						b = bullets.get(i);
					} catch (IndexOutOfBoundsException e) {
						i = bullets.size();
					}
					b.draw(canvasGraphics, player.getxPos(), player.getyPos(), PLAY_AREA_WIDTH, PANEL_HEIGHT);
					
				}
			}
			
			if(enemyBullets != null) {
				BulletSprite b = null;
				for(int i = 0; i < enemyBullets.size(); i++) {
					try {
						b = enemyBullets.get(i);
					} catch (IndexOutOfBoundsException e) {
						i = enemyBullets.size();
					}
					b.draw(canvasGraphics, player.getxPos(), player.getyPos(), PLAY_AREA_WIDTH, PANEL_HEIGHT);
					
				}
			}

			if(customNpcs != null) {
				for(CustomNpc npc : customNpcs) {
					npc.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
			}
			
			player.draw(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT, this.commentarySwitchedOn, this.rain != null );
			
			if(fadingEnemies != null) {
				FadingEnemySprite enemy = null;
				for(int i = 0; i < fadingEnemies.size(); i++) {
					enemy = fadingEnemies.get(i);
					enemy.draw(canvasGraphics, player.getxPos(), player.getyPos(), PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
			}
			
			if(enemies != null) {
				EnemySprite enemy = null;
				for(int i = 0; i < enemies.size(); i++) {
					enemy = enemies.get(i);
					enemy.draw(canvasGraphics, player, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
			}
			
			
			if(items != null) {
				ItemSprite item = null;
				for(int i = 0; i < items.size(); i++) {
					item = items.get(i);
					item.draw(canvasGraphics, player.getxPos(), player.getyPos(), this.PLAY_AREA_WIDTH, this.PANEL_HEIGHT);
				}
			}

			
			if(hurtzones != null) {
				for(HurtzoneSprite hz : hurtzones) {
					hz.draw(canvasGraphics, player.getxPos(), player.getyPos());
				}
			}
			
			
			if(foregroundWidgets != null) {
				for(WidgetSprite w : foregroundWidgets) {
					w.draw(canvasGraphics, player.getxPos(), player.getyPos(), this.PLAY_AREA_WIDTH, this.PANEL_HEIGHT);
				}
			}
			if(rain != null) {
				rain.draw(canvasGraphics);
			}
			
			
			
			player.drawStatuses(canvasGraphics);
			
			
	//		if(!hasImagesLoaded) {
	//			canvasGraphics.setColor(Color.WHITE);
	//	//		canvasGraphics.setColor(new Color(100, 100, 100));
	//			canvasGraphics.fillRect(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT);
	//		}
			
	//		if(!gameRunning && !wasGameEverStarted) {
	//			
	//			//System.out.println("game was never started and is not running.");
	//			
	//			Color prevColor = canvasGraphics.getColor();
	//			
	//			Font origFont = canvasGraphics.getFont();
	//			Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
	//			canvasGraphics.setFont(newFont);
	//			
	//			
	//			canvasGraphics.setColor(Color.RED);
	//			canvasGraphics.drawString("GAME OVER", PLAY_AREA_WIDTH / 2 - 50, PANEL_HEIGHT / 2 - 30);
	//			
	//			newFont = new Font(origFont.getName(), Font.PLAIN, 12);
	//			canvasGraphics.setColor(Color.BLUE);
	//			canvasGraphics.setFont(newFont);
	//			canvasGraphics.drawString("press F2 to begin HHHHAWW", PLAY_AREA_WIDTH / 2 - 41, PANEL_HEIGHT / 2 + 20);
	//			
	//			
	//			canvasGraphics.setColor(prevColor);
	//			canvasGraphics.setFont(origFont);
	//			
	//			return;
	//		} else if(!gameRunning) {
	//			
	//			//System.out.println("trying to draw an end page in gameDraw");
	//			
	//			if(hasImagesLoaded) {
	//			
	//				
	//				return;
	//			}
	//		}
	//			//background drawn here
	//			
	//		//game elements drawn here
	//		
	//		if(!shouldNotExit) {
	//			canvasGraphics.drawString("GAME OVER", (int) (this.getWidth() * 0.4), (int)(this.getHeight() + 0.4) ); 
	//		}
	//		
	//		
	//		
	//		
	//		if(!gameRunning) {
	//			Color prevColor = canvasGraphics.getColor();
	//			
	//			Font origFont = canvasGraphics.getFont();
	//			Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
	//			canvasGraphics.setFont(newFont);
	//			
	//			
	//			canvasGraphics.setColor(Color.RED);
	//			canvasGraphics.drawString("GAME OVER", PLAY_AREA_WIDTH / 2 - 50, PANEL_HEIGHT / 2 - 30);
	//			
	////			newFont = new Font(origFont.getName(), Font.PLAIN, 12);
	////			canvasGraphics.setFont(newFont);
	////			canvasGraphics.setColor(Color.BLUE);
	////			canvasGraphics.drawString("press F2 to begin", PLAY_AREA_WIDTH / 2 - 41, PANEL_HEIGHT / 2 + 20);
	//			
	//			canvasGraphics.setColor(prevColor);
	//			canvasGraphics.setFont(origFont);
	//		}
			
			
			if(this.deathUnfadeTicks > 0) {
				Color newCol = new Color(255,255,255, 255 * deathUnfadeTicks / this.SEGUE_FRAMES);
				Color origCol = canvasGraphics.getColor();
				
				canvasGraphics.setColor(newCol);
				
				
				canvasGraphics.fillRect(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				canvasGraphics.setColor(origCol);
			} else if(this.doorUnfadeTicks > 0) {
				Color newCol = new Color(0,0,0, 255 * doorUnfadeTicks / this.SEGUE_FRAMES);
				Color origCol = canvasGraphics.getColor();
				
				canvasGraphics.setColor(newCol);
				
				canvasGraphics.fillRect(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				canvasGraphics.setColor(origCol);
			}
			
		}
		
		
		drawMenuIfRelevant();
		
		canvasGraphics.dispose();
		
		
		/*if(isPaused) {
			
			if(isShowingAbout) {
				aboutImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
			} else if(isShowingStory) {
				storyImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
			} else {
				
				
				double scalar = Math.random();
				Color origCol = canvasGraphics.getColor();
				canvasGraphics.setColor(PlayingWithCosine.scalarToColor(scalar));
				
				
				if(isConfirmingExit) {
					confirmExitMenuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
					
					if(menuPosition == MENU_POSITION_CONFIRM_NO) 
						canvasGraphics.drawRect(285, 285, 70, 45);
					else if(menuPosition == MENU_POSITION_CONFIRM_YES)
						canvasGraphics.drawRect(425, 285, 75, 45);
					
				} else if(isConfirmingNew || isConfirmingNewSpecial) {
					confirmNewMenuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
	
					if(menuPosition == MENU_POSITION_CONFIRM_NO) 
						canvasGraphics.drawRect(285, 285, 70, 45);
					else if(menuPosition == MENU_POSITION_CONFIRM_YES)
						canvasGraphics.drawRect(425, 285, 75, 45);
					
				} else {
					
					if(canResume) {
						if(canDoCommentary) {
							beatenMenuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
						} else {
							menuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
						}
					} else {
						if(canDoCommentary) {
							beatenMenuImageNoResume.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
						} else {
							menuImageNoResume.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
						}
					}
						
					//new game
					if(menuPosition == MENU_POSITION_NEW)
						canvasGraphics.drawRect(160, 273, 200, 45);
		//			canvasGraphics.drawLine(160, 273, 360, 318);
					
					//resume game
					if(menuPosition == MENU_POSITION_RESUME)
						canvasGraphics.drawRect(445, 273, 160, 45);
					
					//story
					if(menuPosition == MENU_POSITION_STORY)
						canvasGraphics.drawRect(203, 333, 105, 45);
					
					//about
					if(menuPosition == MENU_POSITION_ABOUT)
						canvasGraphics.drawRect(462, 330, 115, 45);
					
					//commentary
					if(menuPosition == MENU_POSITION_NEW_SPECIAL)
						canvasGraphics.drawRect(155, 397, 245, 45);
					
					//exit
					if(menuPosition == MENU_POSITION_EXIT)
						canvasGraphics.drawRect(477, 397, 80, 45);
					
				}
					
	
				canvasGraphics.setColor(origCol);
			}
		}*/
		
		
		
	}
	
	public void drawMenuIfRelevant() {
		if(isPaused) {
			
			if(isShowingCommentaryUnlocked) {
				
				commentaryEnabledImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
				
				double scalar = Math.random();
				Color origCol = canvasGraphics.getColor();
				canvasGraphics.setColor(PlayingWithCosine.scalarToColor(scalar));
				canvasGraphics.drawRect(261, 311, 240, 30);
				canvasGraphics.setColor(origCol);
				
			} else if(isShowingAbout) {
				aboutImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, (PANEL_HEIGHT + 112) / 2);
			} else if(isShowingStory) {
				storyImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, (PANEL_HEIGHT + 112) / 2);
			} else if(isShowingQuickKeyReference) {
				quickKeyReferenceImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
				double scalar = Math.random();
				Color origCol = canvasGraphics.getColor();
				canvasGraphics.setColor(PlayingWithCosine.scalarToColor(scalar));
				canvasGraphics.drawRect(263, 155, 240, 30);
				canvasGraphics.setColor(origCol);
			} else {
				
				
				double scalar = Math.random();
				Color origCol = canvasGraphics.getColor();
				canvasGraphics.setColor(PlayingWithCosine.scalarToColor(scalar));
				
				
				if(isShowingSaveExitMenu) {
					saveOrExitMenuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
					
//					if(menuPosition == MENU_POSITION_CONFIRM_NO) 
//						canvasGraphics.drawRect(285, 285, 70, 45);
//					else if(menuPosition == MENU_POSITION_CONFIRM_YES)
//						canvasGraphics.drawRect(425, 285, 75, 45);
					
					if(menuPosition == MENU_POSITION_EXITMENU_SAVE)
						canvasGraphics.drawRect(185, 270, 100, 45);
					else if (menuPosition == MENU_POSITION_EXITMENU_CANCEL)
						canvasGraphics.drawRect(325, 272, 140, 45);
					else if(menuPosition == MENU_POSITION_EXITMENU_EXIT)
						canvasGraphics.drawRect(515, 272, 75, 45);
					else {
						menuPosition = MENU_POSITION_EXITMENU_CANCEL;
						canvasGraphics.drawRect(325, 272, 140, 45);
					}
					
				} else if(isConfirmingNew || isConfirmingNewTutorial || isConfirmingLoad) {
					confirmNewMenuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
	
					if(menuPosition == MENU_POSITION_CONFIRM_NO) 
						canvasGraphics.drawRect(285, 257, 70, 45);
					else if(menuPosition == MENU_POSITION_CONFIRM_YES)
						canvasGraphics.drawRect(425, 257, 75, 45);
					else {
						menuPosition = MENU_POSITION_CONFIRM_NO;
						canvasGraphics.drawRect(285, 257, 70, 45);;
					}
						
					
				} else if(isSelectingNew) {
					adventureLoadTutorialMenuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
					
					
					if(menuPosition == MENU_POSITION_ADVENTURE) 
						canvasGraphics.drawRect(230, 214, 195, 45);
					else if(menuPosition == MENU_POSITION_LOAD)
						canvasGraphics.drawRect(460, 214, 95, 45);
					else if(menuPosition == MENU_POSITION_TUTORIAL)
						canvasGraphics.drawRect(235, 283, 160, 45);
					else if(menuPosition == MENU_POSITION_NEW_CANCEL)
						canvasGraphics.drawRect(420, 283, 130, 45);
					else {
						menuPosition = MENU_POSITION_NEW_CANCEL;
						canvasGraphics.drawRect(420, 283, 130, 45);
					}
					
					
				} else if(isSelectingOptions) {
					
					if(commentaryIsNotLocked) {
						
						if(commentarySwitchedOn) {
							if(musicSwitchedOn) {
								optionsMenuBothOnImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
							} else {
								optionsMenuCommentaryOnImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
							}
						} else {
							if(musicSwitchedOn) {
								optionsMenuMusicOnImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
							} else {
								optionsMenuBothOffImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
							}
						}
						
					} else {
						if(musicSwitchedOn) {
							optionsMenuLockedOnImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
						} else {
							optionsMenuLockedOffImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
						}
					}
					
					
					switch(menuPosition) {
					case MENU_POSITION_MUSIC_ON:
						canvasGraphics.drawRect(460, 195, 70, 35);
						break;
					case MENU_POSITION_MUSIC_OFF:
						canvasGraphics.drawRect(570, 195, 70, 35);
						break;
					case MENU_POSITION_COMMENTARY_ON:
						canvasGraphics.drawRect(460, 310, 70, 35);
						break;
					case MENU_POSITION_COMMENTARY_OFF:
						canvasGraphics.drawRect(570, 310, 70, 35);
						break;
					case MENU_POSITION_OPTIONS_BACK:
						canvasGraphics.drawRect(560, 100, 80, 35);
						break;
					default:
						menuPosition = MENU_POSITION_OPTIONS_BACK;
						canvasGraphics.drawRect(560, 100, 80, 35);
					}
					
					
				} else {
					
					if(canResume) {
//						if(canDoCommentary) {
//							beatenMenuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
//						} else {
							menuImage.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
//						}
					} else {
//						if(canDoCommentary) {
//							beatenMenuImageNoResume.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
//						} else {
							menuImageNoResume.drawObject(canvasGraphics, PLAY_AREA_WIDTH/2, PANEL_HEIGHT/2);
//						}
					}
						
					//new game
					if(menuPosition == MENU_POSITION_NEW)
						canvasGraphics.drawRect(160, 188, 200, 45);
		//			canvasGraphics.drawLine(160, 273, 360, 318);
					
					//resume game
					else if(menuPosition == MENU_POSITION_RESUME)
						canvasGraphics.drawRect(445, 188, 160, 45);
					
					//story
					else if(menuPosition == MENU_POSITION_STORY)
						canvasGraphics.drawRect(203, 248, 105, 45);
					
					//about
					else if(menuPosition == MENU_POSITION_ABOUT)
						canvasGraphics.drawRect(462, 245, 115, 45);
					
					//commentary
					else if(menuPosition == MENU_POSITION_OPTIONS)
						canvasGraphics.drawRect(150, 312, 145, 45);
					
					//exit
					else if(menuPosition == MENU_POSITION_EXIT)
						canvasGraphics.drawRect(477, 312, 175, 45);
					
					//keys
					else if(menuPosition == MENU_POSITION_KEYS)
						canvasGraphics.drawRect(340, 250, 90, 50);
					
					//restore
					else if(menuPosition == MENU_POSITION_RESTORE)
						canvasGraphics.drawRect(315, 315, 150, 50);
				
					//leave feedback
					else if(menuPosition == MENU_POSITION_LEAVE_FEEDBACK)
						canvasGraphics.drawRect(168, 370, 180, 90);
					
					//want to help
					else if(menuPosition == MENU_POSITION_WANT_TO_HELP)
						canvasGraphics.drawRect(427, 385, 140, 90);
					
					else {
						if(canResume) {
							menuPosition = MENU_POSITION_RESUME;
							canvasGraphics.drawRect(445, 188, 160, 45);
						} else {
							menuPosition = MENU_POSITION_NEW;
							canvasGraphics.drawRect(160, 188, 200, 45);
						}
					}
					
					
				}
					
	
				canvasGraphics.setColor(origCol);
			}
		}
	}
	
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		if(canvasBuffer != null ) {
			g.drawImage(canvasBuffer, 0, 0, null);
		}
//			System.out.println("<><>DELME paintComponent!!!");
		
//		if(scoreboardBuffer != null && (gameRunning || wasGameEverStarted)) {
//			g.drawImage(scoreboardBuffer, PLAY_AREA_WIDTH, 0, null);
//		} else {
//			////System.out.println("scoreboardBuffer was null!");
//		}
//		if(titleScreenBuffer != null && !gameRunning && !wasGameEverStarted && titleImages != null) {
//			g.drawImage(titleScreenBuffer, 0, 0, null);
//		}
		
	}
	
	public void updateElements() {
		
		Diagnostic.print("========================   NOW BEGINNING updateElements   ======================", "PonyPanel");
		
		

		if(isLoading)
			return;
		
		if(bgm != null) {
			bgm.checkToSeeIfShouldLoop();
		}
		
		if(isPaused)
			return;
		
		
		if(deathSegueTicks > 0) {
			deathSegueTicks--;
			if(deathSegueTicks == 0) {
				this.respawn();
				deathUnfadeTicks = SEGUE_FRAMES;
				stopFrame = null;
			}
			return;
		}
		if(doorSegueTicks > 0) {
			doorSegueTicks--;
			if(doorSegueTicks == 0) {
//				System.out.println("<><>DELME about to call loadRoom...");
				this.loadRoom(roomToBeLoaded, roomToBeLoadedPlayerX, roomToBeLoadedPlayerY, false);
				doorUnfadeTicks = SEGUE_FRAMES;
				stopFrame = null;
//				System.out.println("<><>DELME came back from loadRoom!");
			}
			
			return;
		}
		
		if(doorUnfadeTicks > 0) {
			doorUnfadeTicks--;
		}
		if(deathUnfadeTicks > 0) {
			deathUnfadeTicks--;
		}
		
		if(radios != null) {
			for(int i = 0; i < radios.size(); i++) {
				radios.get(i).checkToSeeIfBgmShouldRestart();
			}
		}
		
		
		
		if(blockManager != null) {

			int playerXPos = player.getxPos();
			int playerYPos = player.getyPos();
			
			if(playerXPos < 0 || playerXPos > blockManager.getTotalWidth())
				this.playerDied();
			else if(playerYPos < 0 || playerYPos > blockManager.getTotalHeight())
				this.playerDied();
			
		}
		
		MovingBlockSprite movBlock = null;
		ConveyorBlockSprite conBlock = null;
		for(int i = 0; i < blocks.size(); i++) {
			
			if(blocks.get(i) instanceof MovingBlockSprite) {
				movBlock = (MovingBlockSprite) blocks.get(i);
				
				movBlock.update(player);
			} else if(blocks.get(i) instanceof ConveyorBlockSprite) {
				conBlock = (ConveyorBlockSprite) blocks.get(i);
				conBlock.update(player);
			}
			
		}
		
		for(int i = 0; i < marquisSprites.size(); i++) {
			marquisSprites.get(i).update();
			if(marquisSprites.get(i).isPastThreshold()) {
				marquisSprites.remove(i);
				i--;
			}
		}
		
		if(goalSprite != null) {
			goalSprite.update(player, this);
		}
		
		if(rain != null) {
			rain.update();
		}
		
		if(customNpcs != null) {
			for(CustomNpc npc : customNpcs) {
				npc.update(player, blockManager, blocks);
			}
		}
		
		int direction;
		if(playerIsGoingLeft) {
			if(playerIsGoingUp) {
				direction = 8;
			} else if(playerIsGoingDown) {
				direction = 6;
			} else {
				direction = 7;
			}
		} else if(playerIsGoingRight) {
			if(playerIsGoingUp) {
				direction = 2;
			} else if(playerIsGoingDown) {
				direction = 4;
			} else {
				direction = 3;
			}
		} else {
			if(playerIsGoingUp) {
				direction = 1;
			} else if(playerIsGoingDown) {
				direction = 5;
			} else {
				direction = 0;
			}
		}
		
		
		
		ArrayList<DoorSprite> allDoors = new ArrayList<DoorSprite>();
		if(doors != null)
			allDoors.addAll(doors);
		if(commentarySwitchedOn && commentDoors != null)
			allDoors.addAll(commentDoors);
		
//		player.update(direction, blocks, blockManager);
		player.updateVI(blocks, blockManager, playerIsGoingUp, playerIsGoingLeft, playerIsGoingRight, playerIsInteracting, enemies, allDoors, this, bossSprite, goalSprite, playerIsFiring, commentarySwitchedOn ? radios : new ArrayList<RadioSprite>(), hurtzones);
//		player.updateIII(blocks, blockManager, playerIsGoingUp, playerIsGoingLeft, playerIsGoingRight, playerIsGoingDown);
		
		allDoors.clear();

		Diagnostic.print("========================   NOW ENDING updateElements   ======================", "PonyPanel");
		

		Diagnostic.print("", "PonyPanel");
		Diagnostic.print("", "PonyPanel");
		
		
		
		if(playerIsFiring) {
			fireBullet();
		}
		
		EnemySprite enemy = null;
		if(enemies != null) {
			for(int i = 0; i < enemies.size(); i++) {
				enemy = enemies.get(i);
				enemy.update(player, this);
			}
		}
		
		if(bullets != null) {
			for(int i = 0; i < bullets.size(); i++){
				bullets.get(i).update();
				if(bullets.get(i).canErase(player, PLAY_AREA_WIDTH, PANEL_HEIGHT)) {
					bullets.remove(i);
					i--;
				}
			}
		}
		
		IntRect playerCollisionRect = player.getCurrentPosCollisionRect();
		
		if(enemyBullets != null) {
			for(int i = 0; i < enemyBullets.size(); i++) {
				enemyBullets.get(i).update();
				if(enemyBullets.get(i).getCollisionRect().intersects(playerCollisionRect)) {
					player.takeDamage();
					enemyBullets.remove(i);
					i--;
				} else if(enemyBullets.get(i).canErase(player, PLAY_AREA_WIDTH, PANEL_HEIGHT)) {
					enemyBullets.remove(i);
					i--;
				}
			}
		}
		
		if(fadingEnemies != null) {
			for(int i = 0; i < fadingEnemies.size(); i++) {
				if(fadingEnemies.get(i).updateReturnTrueIfDestroyable()) {
					fadingEnemies.remove(i);
					i--;
//					//System.out.println("just removed a fading enemy; size of fadingEnemies is: " + fadingEnemies.size());
				}
			}
		}
		
		
		IntRect enemyRect = null;
		BulletSprite bullet = null;
		IntRect bulletRect = null;
		if(enemies != null) {
			for(int i = 0; i < enemies.size() && i >= 0; i++) {
				
				enemy = enemies.get(i);
				enemyRect = enemy.getCollisionRect();
				
				for(int j = 0; j < bullets.size(); j++) {
					
					bullet = bullets.get(j);
					
					if(!bullet.isFriendly())
						continue;
					
					bulletRect = bullet.getCollisionRect();
					
					if(bulletRect.intersects(enemyRect)) {
						bullets.remove(j);
						j--;
						
						if(enemy.takeDamageReturnDied(bullet.getDamage())) {
							enemies.remove(enemy);
							i--;
							FadingEnemySprite newFadingEnemy = new FadingEnemySprite(enemy.getxPos(), enemy.getyPos(), enemy.getFacing());
							fadingEnemies.add(newFadingEnemy);
							if(bullet.getOriginatingPony() == PlayerSprite.RARITY || bullet.shouldSpawnHeart()) {
								
								ItemSprite newHeart = new ItemSprite(ItemSprite.HEART, enemy.getxPos(), enemy.getyPos(), itemImageManager);
								items.add(newHeart);
							}
						}
					}
					
				}
				
			}
		}
		
		if(bossSprite != null) {
			bossSprite.update(this, player, enemyImageManager, items);
			
			if(!bossSprite.isAlive()) {
				
				items.add(new ItemSprite(ItemSprite.BOSS_CHECKPOINT_FLAG, bossSprite.getFlagSpawnX(), bossSprite.getFlagSpawnY(), itemImageManager));
				
				bossSprite = null;
				
			} else if(bossSprite.isVisible()) {
				
				enemyRect = bossSprite.getCollisionRect();
				
				for(int i = 0; i < bullets.size(); i++) {
					
					bullet = bullets.get(i);
					
					bulletRect = bullet.getCollisionRect();
					
					if(bulletRect.intersects(enemyRect)) {
						bullets.remove(i);
						i--;
						
						bossSprite.takeDamage(bullet.getDamage());
						
						
					}
					
				}
			}
		}
		
		
		ItemSprite item = null;
		IntRect playerRect = player.getCurrentPosCollisionRect();
		IntRect itemRect = null;
		if(items != null) {
			
			for(int i = 0; i < items.size(); i++) {
				item = items.get(i);
				item.update();
				itemRect = item.getCollisionRect();
				if(itemRect.intersects(playerRect)) {
					switch(item.getItemType()) {
					default:
					case ItemSprite.HEART:
						if(player.getCurrentPonyHP() < player.getCurrentPonyMaxHP()) {
							player.heal();
							items.remove(i);
							i--;
							marquisSprites.add(new MarquisSprite("+ LIFE", player.getxPos(), player.getyPos(), new Color(255, 0, 0), new Color(255, 0, 255)));
						}
						break;
					case ItemSprite.CHECKPOINT_FLAG:
						roomWhereBossWasKilled = null;
						playerRespawnX = item.getxPos();
						playerRespawnY = item.getyPos();
						playerRespawnRoom = currentRoom;
						player.healAllToMax();
						items.remove(i);
						i--;
						marquisSprites.add(new MarquisSprite("CHECKPOINT", player.getxPos(), player.getyPos(), new Color(0, 255, 0), new Color(0, 128, 0)));
						break;
					case ItemSprite.BOSS_CHECKPOINT_FLAG:
						roomWhereBossWasKilled = this.currentRoom == null ? null : this.currentRoom.getRoomName();
						playerRespawnX = item.getxPos();
						playerRespawnY = item.getyPos();
						playerRespawnRoom = currentRoom;
						player.healAllToMax();
						items.remove(i);
						i--;
						marquisSprites.add(new MarquisSprite("CHECKPOINT", player.getxPos(), player.getyPos(), new Color(0, 255, 0), new Color(0, 128, 0)));
						break;
					}
				}
			}
			
		}
		
		if(foregroundWidgets != null) {
			for(WidgetSprite w : foregroundWidgets) {
				w.update();
			}
		}
		
		if(backgroundWidgets != null) {
			for(WidgetSprite w : backgroundWidgets) {
				w.update();
			}
		}
		
		if(commentWidgets != null) {
			for(WidgetSprite w : commentWidgets) {
				w.update();
			}
		}
		
		if(hurtzones != null) {
			for(HurtzoneSprite hz : hurtzones) {
				hz.update();
			}
		} else {
			//System.out.println("is NULL!!!");
		}
		
		
		
	}
	
	
	
	public void jumpWasPressed() {
		
		playerIsGoingUp = true;
		

		

		
		if(isPaused) {
			switch(menuPosition) {
			case MENU_POSITION_ABOUT:
				if(canResume)
					menuPosition = MENU_POSITION_RESUME;
				break;
			case MENU_POSITION_STORY:
				menuPosition = MENU_POSITION_NEW;
				break;
			case MENU_POSITION_EXIT:
				menuPosition = MENU_POSITION_ABOUT;
				break;
			case MENU_POSITION_OPTIONS:
				menuPosition = MENU_POSITION_STORY;
				break;
			case MENU_POSITION_RESTORE:
				menuPosition = MENU_POSITION_KEYS;
				break;
			case MENU_POSITION_MUSIC_OFF:
			case MENU_POSITION_MUSIC_ON:
				menuPosition = MENU_POSITION_OPTIONS_BACK;
				break;
			case MENU_POSITION_COMMENTARY_OFF:
				menuPosition = MENU_POSITION_MUSIC_OFF;
				break;
			case MENU_POSITION_COMMENTARY_ON:
				menuPosition = MENU_POSITION_MUSIC_ON;
				break;
			case MENU_POSITION_TUTORIAL:
				menuPosition = MENU_POSITION_ADVENTURE;
				break;
			case MENU_POSITION_NEW_CANCEL:
				menuPosition = MENU_POSITION_LOAD;
				break;
			case MENU_POSITION_WANT_TO_HELP:
				menuPosition = MENU_POSITION_EXIT;
				break;
			case MENU_POSITION_LEAVE_FEEDBACK:
				menuPosition = MENU_POSITION_OPTIONS;
				break;
			}
		}
		
	}
	
	public void leftWasPressed() {
		playerIsGoingLeft = true;
		

		if(isPaused) {
			switch(menuPosition) {
			case MENU_POSITION_ABOUT:
				menuPosition = MENU_POSITION_KEYS;
				break;
			case MENU_POSITION_KEYS:
				menuPosition = MENU_POSITION_STORY;
				break;
			case MENU_POSITION_RESUME:
				menuPosition = MENU_POSITION_NEW;
				break;
			case MENU_POSITION_EXIT:
				menuPosition = MENU_POSITION_RESTORE;
				break;
			case MENU_POSITION_RESTORE:
				menuPosition = MENU_POSITION_OPTIONS;
				break;
			case MENU_POSITION_CONFIRM_YES:
				menuPosition = MENU_POSITION_CONFIRM_NO;
				break;
			case MENU_POSITION_LOAD:
				menuPosition = MENU_POSITION_ADVENTURE;
				break;
			case MENU_POSITION_NEW_CANCEL:
				menuPosition = MENU_POSITION_TUTORIAL;
				break;
			case MENU_POSITION_MUSIC_OFF:
				menuPosition = MENU_POSITION_MUSIC_ON;
				break;
			case MENU_POSITION_COMMENTARY_OFF:
				menuPosition = MENU_POSITION_COMMENTARY_ON;
				break;
			case MENU_POSITION_EXITMENU_CANCEL:
				menuPosition = MENU_POSITION_EXITMENU_SAVE;
				break;
			case MENU_POSITION_EXITMENU_EXIT:
				menuPosition = MENU_POSITION_EXITMENU_CANCEL;
				break;
			case MENU_POSITION_WANT_TO_HELP:
				menuPosition = MENU_POSITION_LEAVE_FEEDBACK;
				break;
			}
		}
	}
	
	public void downWasPressed() {
		playerIsGoingDown = true;
		
		if(isPaused) {
			switch(menuPosition) {
			case MENU_POSITION_RESUME:
				menuPosition = MENU_POSITION_ABOUT;
				break;
			case MENU_POSITION_NEW:
				menuPosition = MENU_POSITION_STORY;
				break;
			case MENU_POSITION_ABOUT:
				menuPosition = MENU_POSITION_EXIT;
				break;
			case MENU_POSITION_STORY:
				menuPosition = MENU_POSITION_OPTIONS;
				break;
			case MENU_POSITION_KEYS:
				menuPosition = MENU_POSITION_RESTORE;
				break;
			case MENU_POSITION_ADVENTURE:
				menuPosition = MENU_POSITION_TUTORIAL;
				break;
			case MENU_POSITION_LOAD:
				menuPosition = MENU_POSITION_NEW_CANCEL;
				break;
			case MENU_POSITION_MUSIC_ON:
				menuPosition = MENU_POSITION_COMMENTARY_ON;
				break;
			case MENU_POSITION_MUSIC_OFF:
				menuPosition = MENU_POSITION_COMMENTARY_OFF;
				break;
			case MENU_POSITION_OPTIONS_BACK:
				menuPosition = MENU_POSITION_MUSIC_OFF;
				break;
			case MENU_POSITION_OPTIONS:
				menuPosition = MENU_POSITION_LEAVE_FEEDBACK;
				break;
			case MENU_POSITION_EXIT:
				menuPosition = MENU_POSITION_WANT_TO_HELP;
				break;
			}
			
			if(!commentaryIsNotLocked) {
				if(menuPosition == MENU_POSITION_COMMENTARY_OFF)
					menuPosition = MENU_POSITION_MUSIC_OFF;
				else if(menuPosition == MENU_POSITION_COMMENTARY_ON)
					menuPosition = MENU_POSITION_MUSIC_ON;
			}
			
		}
	}
	
	public void rightWasPressed() {
		playerIsGoingRight = true;
		
		
		if(isPaused) {
			switch(menuPosition) {
			case MENU_POSITION_STORY:
				menuPosition = MENU_POSITION_KEYS;
				break;
			case MENU_POSITION_KEYS:
				menuPosition = MENU_POSITION_ABOUT;
				break;
			case MENU_POSITION_NEW:
				if(canResume)
					menuPosition = MENU_POSITION_RESUME;
				break;
			case MENU_POSITION_OPTIONS:
				menuPosition = MENU_POSITION_RESTORE;
				break;
			case MENU_POSITION_RESTORE:
				menuPosition = MENU_POSITION_EXIT;
				break;
			case MENU_POSITION_CONFIRM_NO:
				menuPosition = MENU_POSITION_CONFIRM_YES;
				break;
			case MENU_POSITION_ADVENTURE:
				menuPosition = MENU_POSITION_LOAD;
				break;
			case MENU_POSITION_TUTORIAL:
				menuPosition = MENU_POSITION_NEW_CANCEL;
				break;
			case MENU_POSITION_MUSIC_ON:
				menuPosition = MENU_POSITION_MUSIC_OFF;
				break;
			case MENU_POSITION_COMMENTARY_ON:
				menuPosition = MENU_POSITION_COMMENTARY_OFF;
				break;
			case MENU_POSITION_EXITMENU_SAVE:
				menuPosition = MENU_POSITION_EXITMENU_CANCEL;
				break;
			case MENU_POSITION_EXITMENU_CANCEL:
				menuPosition = MENU_POSITION_EXITMENU_EXIT;
				break;
			case MENU_POSITION_LEAVE_FEEDBACK:
				menuPosition = MENU_POSITION_WANT_TO_HELP;
				break;
			}
		}
	}
	
	public void fireWasPressed() {
		
		if(isPaused) {
			

			if(isShowingAbout) {
				isShowingAbout = false;
				return;
			}
			
			if(isShowingCommentaryUnlocked) {
				isShowingCommentaryUnlocked = false;
				return;
			}
			
			if(isShowingStory) {
				isShowingStory = false;
				return;
			}
			if(isShowingQuickKeyReference) {
				isShowingQuickKeyReference = false;
				return;
			}
			
			
//			public static final int MENU_POSITION_NEW = 1;
//			public static final int MENU_POSITION_RESUME = 2;
//			public static final int MENU_POSITION_STORY = 3;
//			public static final int MENU_POSITION_ABOUT = 4;
//			public static final int MENU_POSITION_OPTIONS = 5;
//			public static final int MENU_POSITION_EXIT = 6;
//			
//			public static final int MENU_POSITION_CONFIRM_NO = 7;
//			public static final int MENU_POSITION_CONFIRM_YES = 8;
//			
//			public static final int MENU_POSITION_ADVENTURE = 9;
//			public static final int MENU_POSITION_LOAD = 10;
//			public static final int MENU_POSITION_TUTORIAL = 11;
//			public static final int MENU_POSITION_NEW_CANCEL = 12;
//			
//			public static final int MENU_POSITION_MUSIC_ON = 13;
//			public static final int MENU_POSITION_MUSIC_OFF = 14;
//			public static final int MENU_POSITION_COMMENTARY_ON = 15;
//			public static final int MENU_POSITION_COMMENTARY_OFF = 16;
//			public static final int MENU_POSITION_OTPIONS_BACK = 17;
			
			switch(menuPosition) {
			case MENU_POSITION_EXIT:
				isShowingSaveExitMenu = true;
				menuPosition = MENU_POSITION_EXITMENU_CANCEL;
				break;
			
			case MENU_POSITION_EXITMENU_CANCEL:
			case MENU_POSITION_CONFIRM_NO:
				if(isShowingSaveExitMenu) {
					menuPosition = MENU_POSITION_EXIT;
				} else if(isConfirmingNew || isConfirmingLoad || isConfirmingNewTutorial) {
					menuPosition = MENU_POSITION_NEW;
				}
				isShowingSaveExitMenu = false;
				isConfirmingNew = false;
				isConfirmingLoad = false;
				isConfirmingNewTutorial = false;
				isSelectingNew = false;
				break;
			
			case MENU_POSITION_NEW:
				isSelectingNew = true;
				menuPosition = MENU_POSITION_ADVENTURE;
				break;
			case MENU_POSITION_ADVENTURE:
				isSelectingNew = false;
				isConfirmingNew = true;
				menuPosition = MENU_POSITION_CONFIRM_NO;
				break;
			case MENU_POSITION_LOAD:
				isSelectingNew = false;
				isConfirmingLoad = true;
				menuPosition = MENU_POSITION_CONFIRM_NO;
				break;
			case MENU_POSITION_OPTIONS_BACK:
				isSelectingOptions = false;
				menuPosition = MENU_POSITION_OPTIONS;
				break;
			case MENU_POSITION_RESTORE:
				restoreGame();
				break;
			case MENU_POSITION_OPTIONS:
				isSelectingOptions = true;
				menuPosition = MENU_POSITION_OPTIONS_BACK;
				break;
			case MENU_POSITION_COMMENTARY_ON:
				if(commentaryIsNotLocked) {
					commentarySwitchedOn = true;
				} else {
					commentarySwitchedOn = false;
					menuPosition = MENU_POSITION_MUSIC_ON;
				}
				break;
			case MENU_POSITION_COMMENTARY_OFF:
				commentarySwitchedOn = false;
				break;
			case MENU_POSITION_MUSIC_ON:
				musicSwitchedOn = true;
				if(bgm != null) {
					bgm.startFromBeginning();
					if(radioIsRunning()) {
						bgm.pause();
					}
				}
				break;
				
			case MENU_POSITION_MUSIC_OFF:
				musicSwitchedOn = false;
				if(bgm != null)
					bgm.pause();
				break;
			
			case MENU_POSITION_NEW_CANCEL:
				isSelectingNew = false;
				
				menuPosition = MENU_POSITION_NEW;
				break;
				
			case MENU_POSITION_TUTORIAL:
				//no idea
				
				isConfirmingNewTutorial = true;
				menuPosition = MENU_POSITION_CONFIRM_NO;
				
				break;
			case MENU_POSITION_EXITMENU_SAVE:
				writeSaveFile();
				break;
			
			case MENU_POSITION_EXITMENU_EXIT:
				exitGame();
				break;
			case MENU_POSITION_CONFIRM_YES:
				if(isConfirmingNew) {
					//need to start a new game
					
					if(!mainLevel.loadingComplete()) {
						
						if(mainLevel.getRoom(mainLevel.getLevelStartRoomName()) == null) {
							
							roomIsntEvenLoaded = true;
							
							while(mainLevel.getRoom(mainLevel.getLevelStartRoomName()) == null) {
								
//								this.gameDraw();
//								
//								
//								this.repaint();
								
								try {
									Thread.sleep(100L);
								} catch(Exception e) {
//									e.printStackTrace();
									break;
								}
								
								
							}
							
							roomIsntEvenLoaded = false;
						}
						
					}
					
					player.healAllToMax();
					player.loadingLevel(true);
					player.loadingLevelNoCustomCharacters();
					loadRoom(mainLevel.getRoom(mainLevel.getLevelStartRoomName()), mainLevel.getLevelStartX(), mainLevel.getLevelStartY(), false);
					
					this.playerRespawnRoom = mainLevel.getRoom(mainLevel.getLevelStartRoomName());
					this.playerRespawnX = mainLevel.getLevelStartX();
					this.playerRespawnY = mainLevel.getLevelStartY();
					
					loadLevel = null;
					
//					RoomData controlRoom = mainLevel.getRoom("Control Room");
//					GoalSprite aGoal = controlRoom.getGoal();
//					aGoal.resetGoalButton();
					
					RoomData controlRoom = mainLevel.getRoom("Control Room");
					if(controlRoom != null) { //may not be loaded yet
						GoalSprite aGoal = controlRoom.getGoal();
						if(aGoal != null)
							aGoal.resetGoalButton();
					}
					
					player.endCutsceneMode();
					canResume = true;
					
					stopFrame = null;
					doorSegueTicks = 0;
					deathSegueTicks = 0;
					doorUnfadeTicks = 0;
					roomToBeLoaded = null;
					isShowingEndingCutscene = false;
					

					if(rain == null) {
						rain = new RainSprite(new Color(50, 100, 200));
					} else {
						rain.setShouldRain(true);
						
					}
					
					BackgroundMusic newBgm = BackgroundMusic.getDefault();
//					if(bgm != null && bgm != newBgm) {
						bgm.pause();
						bgm.dispose();
//					}
					bgm = newBgm;
					if(bgm != null & musicSwitchedOn)
						bgm.start();
					menuPosition = MENU_POSITION_RESUME;
					isConfirmingNew = false;
					isSelectingNew = false;
					isPaused = false;
					
				} else if(isConfirmingLoad) {
					//need to load up a game
					
					

					loadLevelFromDialog();
					
					if(loadLevel != null) {
						isFromFiles = true;
						player.healAllToMax();
						player.loadingLevel(loadLevel.shouldHaveRain());
						
						//JOptionPane.showMessageDialog(null, "<html> <><>DELME loadLevel.getLevelStartRoomName(): `"+loadLevel.getLevelStartRoomName()+"`<br> is tjhe room null? " +(null == loadLevel.getRoom(loadLevel.getLevelStartRoomName()))+ "</html>");
						
						loadRoom(loadLevel.getRoom(loadLevel.getLevelStartRoomName()), loadLevel.getLevelStartX(), loadLevel.getLevelStartY(), false);
						//System.err.println("<><>DELME about to spawn at " + loadLevel.getLevelStartX() + ", " + loadLevel.getLevelStartY());
						
						
						
						this.playerRespawnRoom = loadLevel.getRoom(loadLevel.getLevelStartRoomName());
						this.playerRespawnX = loadLevel.getLevelStartX();
						this.playerRespawnY = loadLevel.getLevelStartY();

						player.endCutsceneMode();
						canResume = true;
						
						isPaused = false;
						isShowingSaveExitMenu = false;
						isConfirmingLoad = false;
						isConfirmingNew = false;
						isConfirmingNewTutorial = false;
						isShowingEndingCutscene = false;
						stopFrame = null;
						doorSegueTicks = 0;
						deathSegueTicks = 0;
						doorUnfadeTicks = 0;
						if(loadLevel.shouldHaveRain()) {
							rain = new RainSprite(new Color(50, 100, 200));
						} else {
							rain = null;
						}
						BackgroundMusic newBgm = loadLevel.getBgm();
//						if(this.bgm != null && this.bgm != newBgm) {
							this.bgm.pause();
							this.bgm.dispose();
//						}
						this.bgm = newBgm;
						if(this.bgm != null && musicSwitchedOn) {
							this.bgm.startFromBeginning();
						}
						
						
					}
					
				} else if(isConfirmingNewTutorial) {
					//need to start a special new game---which kind depends on whether the game's been beaten or not.
					//EDIT:  no, commentary can be switched on or off.  Tutorial is tutorial.
//					if(!this.canDoCommentary) {
						player.healAllToMax();
						player.loadingLevel(true);
						player.loadingLevelNoCustomCharacters();
						loadRoom(tutorialLevel.getRoom(tutorialLevel.getLevelStartRoomName()), tutorialLevel.getLevelStartX(), tutorialLevel.getLevelStartY(), false);
						
						this.playerRespawnRoom = tutorialLevel.getRoom(tutorialLevel.getLevelStartRoomName());
						this.playerRespawnX = tutorialLevel.getLevelStartX();
						this.playerRespawnY = tutorialLevel.getLevelStartY();
						
						tutorialLevel.getRoom("goalRoom").getGoal().resetGoalButton();
						
						loadLevel = null;

						player.endCutsceneMode();
						canResume = true;
						
						stopFrame = null;
						doorSegueTicks = 0;
						deathSegueTicks = 0;
						doorUnfadeTicks = 0;
						roomToBeLoaded = null;
						isShowingEndingCutscene = false;
						
						BackgroundMusic newBgm = tutorialLevel.getBgm();
						if(bgm != null && bgm != newBgm) {
							bgm.pause();
							bgm.dispose();
						}
						bgm = newBgm;
						if(bgm != null & musicSwitchedOn)
							bgm.start();
						
						if(rain == null) {
							rain = new RainSprite(new Color(50, 100, 200));
						} else {
							rain.setShouldRain(true);
							
						}
						
						menuPosition = MENU_POSITION_RESUME;
						isConfirmingNewTutorial = false;
						isSelectingNew = false;
						isPaused = false;
//					}
				}
				break;
			case MENU_POSITION_RESUME:
				if(canResume)
					isPaused = false;
				break;
			case MENU_POSITION_STORY:
				isShowingStory = true;
				break;
			case MENU_POSITION_ABOUT:
				isShowingAbout = true;
				break;
			case MENU_POSITION_KEYS:
				isShowingQuickKeyReference = true;
				break;
			case MENU_POSITION_LEAVE_FEEDBACK:
				openLeaveFeedbackScreen();
				break;
			case MENU_POSITION_WANT_TO_HELP:
				openWantToHelpScreen();
				break;
			}
			
			
			
		} else {
			
			playerIsFiring = true;
		}
		
	}
	
	public void enterWasPressed() {

		if(isPaused) {
			


			if(isShowingAbout) {
				if(!Desktop.isDesktopSupported()) {
					
					JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there's no feature for opening browser windows from Java programs.<br>" +
							"You'll need to open one yourself and go to https://www.fanfiction.net/s/8279941/1/The-Devil-s-Stallion</html>");
					
				} else {
					Desktop desktop = Desktop.getDesktop();
			        if (desktop.isSupported(Desktop.Action.BROWSE)) {
			        	try {
			        		desktop.browse(new URI("https://www.fanfiction.net/s/8279941/1/The-Devil-s-Stallion"));
			        	} catch(Exception e) {
			        		JOptionPane.showMessageDialog(null, PonyPanel.formatStackTrace(e),"Error while trying to navigate to web page", JOptionPane.ERROR_MESSAGE);
			        	}
			        } else {
			        	JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there isn't a feature for opening browser windows from java programs.<br>" +
								"You'll need to open one yourself and go to https://www.fanfiction.net/s/8279941/1/The-Devil-s-Stallion</html>");
			        }
				}
				return;
			}
			
			if(isShowingCommentaryUnlocked) {
				isShowingCommentaryUnlocked = false;
				return;
			}
			
			if(isShowingStory) {
				isShowingStory = false;
				return;
			}
			if(isShowingQuickKeyReference) {
				isShowingQuickKeyReference = false;
				return;
			}
			
			
//			public static final int MENU_POSITION_NEW = 1;
//			public static final int MENU_POSITION_RESUME = 2;
//			public static final int MENU_POSITION_STORY = 3;
//			public static final int MENU_POSITION_ABOUT = 4;
//			public static final int MENU_POSITION_OPTIONS = 5;
//			public static final int MENU_POSITION_EXIT = 6;
//			
//			public static final int MENU_POSITION_CONFIRM_NO = 7;
//			public static final int MENU_POSITION_CONFIRM_YES = 8;
//			
//			public static final int MENU_POSITION_ADVENTURE = 9;
//			public static final int MENU_POSITION_LOAD = 10;
//			public static final int MENU_POSITION_TUTORIAL = 11;
//			public static final int MENU_POSITION_NEW_CANCEL = 12;
//			
//			public static final int MENU_POSITION_MUSIC_ON = 13;
//			public static final int MENU_POSITION_MUSIC_OFF = 14;
//			public static final int MENU_POSITION_COMMENTARY_ON = 15;
//			public static final int MENU_POSITION_COMMENTARY_OFF = 16;
//			public static final int MENU_POSITION_OTPIONS_BACK = 17;
			
			switch(menuPosition) {
			case MENU_POSITION_EXIT:
				isShowingSaveExitMenu = true;
				menuPosition = MENU_POSITION_EXITMENU_CANCEL;
				break;
			
			case MENU_POSITION_EXITMENU_CANCEL:
			case MENU_POSITION_CONFIRM_NO:
				if(isShowingSaveExitMenu) {
					menuPosition = MENU_POSITION_EXIT;
				} else if(isConfirmingNew || isConfirmingLoad || isConfirmingNewTutorial) {
					menuPosition = MENU_POSITION_NEW;
				}
				isShowingSaveExitMenu = false;
				isConfirmingNew = false;
				isConfirmingLoad = false;
				isConfirmingNewTutorial = false;
				isSelectingNew = false;
				break;
			
			case MENU_POSITION_NEW:
				isSelectingNew = true;
				menuPosition = MENU_POSITION_ADVENTURE;
				break;
			case MENU_POSITION_ADVENTURE:
				isSelectingNew = false;
				isConfirmingNew = true;
				menuPosition = MENU_POSITION_CONFIRM_NO;
				break;
			case MENU_POSITION_LOAD:
				isSelectingNew = false;
				isConfirmingLoad = true;
				menuPosition = MENU_POSITION_CONFIRM_NO;
				break;
			case MENU_POSITION_OPTIONS_BACK:
				isSelectingOptions = false;
				menuPosition = MENU_POSITION_OPTIONS;
				break;
			case MENU_POSITION_RESTORE:
				restoreGame();
				break;
			case MENU_POSITION_OPTIONS:
				isSelectingOptions = true;
				menuPosition = MENU_POSITION_OPTIONS_BACK;
				break;
			case MENU_POSITION_COMMENTARY_ON:
				if(commentaryIsNotLocked) {
					commentarySwitchedOn = true;
				} else {
					commentarySwitchedOn = false;
					menuPosition = MENU_POSITION_MUSIC_ON;
				}
				break;
			case MENU_POSITION_COMMENTARY_OFF:
				commentarySwitchedOn = false;
				break;
			case MENU_POSITION_MUSIC_ON:
				musicSwitchedOn = true;
				if(bgm != null) {
					bgm.startFromBeginning();
					if(radioIsRunning()) {
						bgm.pause();
					}
				}
				break;
				
			case MENU_POSITION_MUSIC_OFF:
				musicSwitchedOn = false;
				if(bgm != null)
					bgm.pause();
				break;
			
			case MENU_POSITION_NEW_CANCEL:
				isSelectingNew = false;
				
				menuPosition = MENU_POSITION_NEW;
				break;
				
			case MENU_POSITION_TUTORIAL:
				//no idea
				
				isConfirmingNewTutorial = true;
				menuPosition = MENU_POSITION_CONFIRM_NO;
				
				break;
			case MENU_POSITION_EXITMENU_SAVE:
				writeSaveFile();
				break;
			
			case MENU_POSITION_EXITMENU_EXIT:
				exitGame();
				break;
			case MENU_POSITION_CONFIRM_YES:
				if(isConfirmingNew) {
					//need to start a new game
					
					if(!mainLevel.loadingComplete()) {
						
						if(mainLevel.getRoom(mainLevel.getLevelStartRoomName()) == null) {
							
							roomIsntEvenLoaded = true;
							
							while(mainLevel.getRoom(mainLevel.getLevelStartRoomName()) == null) {
								
//								this.gameDraw();
//								
//								
//								this.repaint();
								
								try {
									Thread.sleep(100L);
								} catch(Exception e) {
//									e.printStackTrace();
									break;
								}
								
								
							}
							
							roomIsntEvenLoaded = false;
						}
						
					}
					
					player.healAllToMax();
					player.loadingLevel(true);
					player.loadingLevelNoCustomCharacters();
					loadRoom(mainLevel.getRoom(mainLevel.getLevelStartRoomName()), mainLevel.getLevelStartX(), mainLevel.getLevelStartY(), false);
					
					this.playerRespawnRoom = mainLevel.getRoom(mainLevel.getLevelStartRoomName());
					this.playerRespawnX = mainLevel.getLevelStartX();
					this.playerRespawnY = mainLevel.getLevelStartY();
					
					loadLevel = null;
					
//					RoomData controlRoom = mainLevel.getRoom("Control Room");
//					GoalSprite aGoal = controlRoom.getGoal();
//					aGoal.resetGoalButton();
					
					RoomData controlRoom = mainLevel.getRoom("Control Room");
					if(controlRoom != null) { //may not be loaded yet
						GoalSprite aGoal = controlRoom.getGoal();
						if(aGoal != null)
							aGoal.resetGoalButton();
					}
					
					player.endCutsceneMode();
					canResume = true;
					
					stopFrame = null;
					doorSegueTicks = 0;
					deathSegueTicks = 0;
					doorUnfadeTicks = 0;
					roomToBeLoaded = null;
					isShowingEndingCutscene = false;
					

					if(rain == null) {
						rain = new RainSprite(new Color(50, 100, 200));
					} else {
						rain.setShouldRain(true);
						
					}
					
					BackgroundMusic newBgm = BackgroundMusic.getDefault();
//					if(bgm != null && bgm != newBgm) {
						bgm.pause();
						bgm.dispose();
//					}
					bgm = newBgm;
					if(bgm != null & musicSwitchedOn)
						bgm.start();
					menuPosition = MENU_POSITION_RESUME;
					isConfirmingNew = false;
					isSelectingNew = false;
					isPaused = false;
					
				} else if(isConfirmingLoad) {
					//need to load up a game
					
					

					loadLevelFromDialog();
					
					if(loadLevel != null) {
						isFromFiles = true;
						player.healAllToMax();
						player.loadingLevel(loadLevel.shouldHaveRain());
						
						//JOptionPane.showMessageDialog(null, "<html> <><>DELME loadLevel.getLevelStartRoomName(): `"+loadLevel.getLevelStartRoomName()+"`<br> is tjhe room null? " +(null == loadLevel.getRoom(loadLevel.getLevelStartRoomName()))+ "</html>");
						
						loadRoom(loadLevel.getRoom(loadLevel.getLevelStartRoomName()), loadLevel.getLevelStartX(), loadLevel.getLevelStartY(), false);
						//System.err.println("<><>DELME about to spawn at " + loadLevel.getLevelStartX() + ", " + loadLevel.getLevelStartY());
						
						
						
						this.playerRespawnRoom = loadLevel.getRoom(loadLevel.getLevelStartRoomName());
						this.playerRespawnX = loadLevel.getLevelStartX();
						this.playerRespawnY = loadLevel.getLevelStartY();

						player.endCutsceneMode();
						canResume = true;
						
						isPaused = false;
						isShowingSaveExitMenu = false;
						isConfirmingLoad = false;
						isConfirmingNew = false;
						isConfirmingNewTutorial = false;
						isShowingEndingCutscene = false;
						stopFrame = null;
						doorSegueTicks = 0;
						deathSegueTicks = 0;
						doorUnfadeTicks = 0;
						if(loadLevel.shouldHaveRain()) {
							rain = new RainSprite(new Color(50, 100, 200));
						} else {
							rain = null;
						}
						BackgroundMusic newBgm = loadLevel.getBgm();
//						if(this.bgm != null && this.bgm != newBgm) {
							this.bgm.pause();
							this.bgm.dispose();
//						}
						this.bgm = newBgm;
						if(this.bgm != null && musicSwitchedOn) {
							this.bgm.startFromBeginning();
						}
						
						
					}
					
				} else if(isConfirmingNewTutorial) {
					//need to start a special new game---which kind depends on whether the game's been beaten or not.
					//EDIT:  no, commentary can be switched on or off.  Tutorial is tutorial.
//					if(!this.canDoCommentary) {
						player.healAllToMax();
						player.loadingLevel(true);
						player.loadingLevelNoCustomCharacters();
						loadRoom(tutorialLevel.getRoom(tutorialLevel.getLevelStartRoomName()), tutorialLevel.getLevelStartX(), tutorialLevel.getLevelStartY(), false);
						
						this.playerRespawnRoom = tutorialLevel.getRoom(tutorialLevel.getLevelStartRoomName());
						this.playerRespawnX = tutorialLevel.getLevelStartX();
						this.playerRespawnY = tutorialLevel.getLevelStartY();
						
						tutorialLevel.getRoom("goalRoom").getGoal().resetGoalButton();
						
						loadLevel = null;

						player.endCutsceneMode();
						canResume = true;
						
						stopFrame = null;
						doorSegueTicks = 0;
						deathSegueTicks = 0;
						doorUnfadeTicks = 0;
						roomToBeLoaded = null;
						isShowingEndingCutscene = false;
						
						BackgroundMusic newBgm = tutorialLevel.getBgm();
						if(bgm != null && bgm != newBgm) {
							bgm.pause();
							bgm.dispose();
						}
						bgm = newBgm;
						if(bgm != null & musicSwitchedOn)
							bgm.start();
						
						if(rain == null) {
							rain = new RainSprite(new Color(50, 100, 200));
						} else {
							rain.setShouldRain(true);
							
						}
						
						menuPosition = MENU_POSITION_RESUME;
						isConfirmingNewTutorial = false;
						isSelectingNew = false;
						isPaused = false;
//					}
				}
				break;
			case MENU_POSITION_RESUME:
				if(canResume)
					isPaused = false;
				break;
			case MENU_POSITION_STORY:
				isShowingStory = true;
				break;
			case MENU_POSITION_ABOUT:
				isShowingAbout = true;
				break;
			case MENU_POSITION_KEYS:
				isShowingQuickKeyReference = true;
				break;
			case MENU_POSITION_LEAVE_FEEDBACK:
				openLeaveFeedbackScreen();
				break;
			case MENU_POSITION_WANT_TO_HELP:
				openWantToHelpScreen();
				break;
			}
			
			
			
		} else {
			playerIsInteracting = true;
		}
		
	}
	
	public void escapeWasPressed() {
		if(!isPaused) {
			isPaused = true;
			if(canResume)
				menuPosition = MENU_POSITION_RESUME;
			else
				menuPosition = MENU_POSITION_NEW;
		} else {
			
			isShowingSaveExitMenu = false;
			isConfirmingLoad = false;
			isConfirmingNew = false;
			isConfirmingNewTutorial = false;
			isSelectingNew = false;
			isShowingAbout = false;
			isShowingCommentaryUnlocked = false;
			isShowingQuickKeyReference = false;
			isShowingStory = false;
			isSelectingOptions = false;
			
			
			if(canResume)
				menuPosition = MENU_POSITION_RESUME;
			else
				menuPosition = MENU_POSITION_NEW;
		}
	}
	
	public void keyWasPressed(KeyEvent e) {
		
		
		if(e.getKeyCode() == KeyEvent.VK_UP) {
			
			jumpWasPressed();
			
		} else if(e.getKeyCode() == KeyEvent.VK_LEFT) {
			
			leftWasPressed();
			
		} else if(e.getKeyCode() == KeyEvent.VK_DOWN) {

			downWasPressed();
			
		} else if(e.getKeyCode() == KeyEvent.VK_RIGHT) {
			
			rightWasPressed();
			
		} else if(e.getKeyCode() == KeyEvent.VK_SPACE) {
			
			fireWasPressed();
			
		} else if(e.getKeyCode() == KeyEvent.VK_ENTER) {
			
			enterWasPressed();
			
		} else if(e.getKeyCode() == KeyEvent.VK_F10) {
			exitGame();
		} else if(e.getKeyCode() == KeyEvent.VK_F3) {
			togglePauseGame();
		} else if(e.getKeyCode() == KeyEvent.VK_F2) {
			newGame();
		} else if(e.getKeyCode() == KeyEvent.VK_ESCAPE) {
			escapeWasPressed();
		} else if(player.hasCustomCharacters()) {
			player.checkButtonForSwitching(e);
		} else if(e.getKeyCode() == KeyEvent.VK_T) {
			if(player != null) {
				player.switchToTwilight();
			}
		} else if(e.getKeyCode() == KeyEvent.VK_A) {
			if(player != null) {
				player.switchToApplejack();
			}
		} else if(e.getKeyCode() == KeyEvent.VK_F){
			if(player != null) {
				player.switchToFluttershy();
			}
		} else if(e.getKeyCode() == KeyEvent.VK_D){
			if(player != null) {
				player.switchToRainbowDash();
			}
		} else if(e.getKeyCode() == KeyEvent.VK_R){
			if(player != null) {
				player.switchToRarity();
			}
		} else if(e.getKeyCode() == KeyEvent.VK_E){
			if(player != null) {
				player.switchToPinkiePie();
			}
//		} else if(e.getKeyCode() == KeyEvent.VK_7){
//			Diagnostic.shouldDisplay = true;
//		} else if(e.getKeyCode() == KeyEvent.VK_1){
//			player.debugSetFalling();
//		} else if(e.getKeyCode() == KeyEvent.VK_0) {
//			loadRoom(currentRoom, Integer.MIN_VALUE, Integer.MIN_VALUE, false);
//		} else if(e.getKeyCode() == KeyEvent.VK_OPEN_BRACKET) {
			
//			ImageIcon fore = currentForeground.getForeground();
//			
//			File outFile = new File("blocks.GIF");
//			
//			BufferedImage bi = new BufferedImage(fore.getIconWidth(), fore.getIconHeight(), BufferedImage.TYPE_INT_RGB);
//			Graphics g = bi.getGraphics();
//			
//			g.drawImage(fore.getImage(), 0, 0, fore.getIconWidth(), fore.getIconHeight(), 0, 0, fore.getIconWidth(), fore.getIconHeight(), null);
//			
//			try {
//				ImageIO.write(bi, "GIF", outFile);
//			} catch (IOException e1) {
//				// TODO Auto-generated catch block
//				e1.printStackTrace();
//			}
			
			
			
//			Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
//			
//			Set<Thread> allThreads = stackTraces.keySet();
//			
//			StackTraceElement[] stack = null;
//			
//			for(Thread t : allThreads) {
//				
//				//System.out.println("dump of the stack trace for thread " + t.getId() + ", which is in state " + t.getState());
//				
//				stack = stackTraces.get(t);
//				
//				for(StackTraceElement ste : stack) {
//					//System.out.println("      >>> " + ste.getFileName() + "." + ste.getMethodName() + " at line " + ste.getLineNumber());
//				}
//				
//				
//				//System.out.println();
//				//System.out.println();
//				//System.out.println();
//			}
			
			
			
//		} else if(e.getKeyCode() == KeyEvent.VK_9) {
//			loadRoom(dummyLevel.getRoom("testRoom1"), Integer.MIN_VALUE, Integer.MIN_VALUE, false);
//		} else if(e.getKeyCode() == KeyEvent.VK_8) {
//			respawn();
//		} else if(e.getKeyCode() == KeyEvent.VK_BACK_SLASH) {
//			player.setSquishy(true);
//		} else if(e.getKeyCode() == KeyEvent.VK_SLASH) {
//			player.setSquishy(false);
		
//		} else if(e.getKeyCode() == KeyEvent.VK_F11) {
//			goToMenuResumeNotAllowed();
//		} else if(e.getKeyCode() == KeyEvent.VK_F12) {
//			goToMenuResumeNotAllowedCommentaryAllowed();
//		} else if(e.getKeyCode() == KeyEvent.VK_6){
//			writeOutForeground();
//		} else if(e.getKeyCode() == KeyEvent.VK_M) {
			
//			if(bgm.isRunning())
//				bgm.pause();
//			else
//				bgm.start();
			
//			toggleMusic();
			
//		} else if(e.getKeyCode() == KeyEvent.VK_L) {
//			isLoading = !isLoading;
//		} else if(e.getKeyCode() == KeyEvent.VK_K) {
//			CustomImageDataIIRepository.dumpEverything();
//		} else if(e.getKeyCode() == KeyEvent.VK_SEMICOLON) {
//			CustomImageDataIIRepository.writeToLog("room progress on the first room: " + CustomImageDataIIRepository.getRoomProgress("wfOutside"));
		}
		
	}
	
	
	public void fireBullet() {
		
//		//System.out.println("<><>DELME      firing!");
		
		if(lastBulletFireTimestamp + 100L > System.currentTimeMillis()) //bullets.size() > 7 || 
			return;
		
		BulletSprite newBullet = null;
		
		
		if(player.hasCustomCharacters()) {
			
			int bulletInitXPos;
			int bulletInitYPos;
			
			CustomPlayableCharacterData customCharData = player.getCurrentCustomCharacterData();
			
			bulletInitXPos = player.getxPos();
			if(player.getFacing() == 'r') {
				bulletInitXPos += customCharData.getBulletSpawnXOffset();
			} else {
				bulletInitXPos -= customCharData.getBulletSpawnXOffset();
			}
			
			bulletInitYPos = player.getyPos() + customCharData.getBulletSpawnYOffset();
			
			newBullet = new BulletSprite(true, player.getFacing(), bulletInitXPos, bulletInitYPos, this, customCharData);
			bullets.add(newBullet);
			
			if(customCharData.isShotsShouldSpread()) {
				if(player.getFacing() == 'r') {
					newBullet = new BulletSprite(true, 'e', bulletInitXPos, bulletInitYPos, this, customCharData);
					bullets.add(newBullet);
					newBullet = new BulletSprite(true, 's', bulletInitXPos, bulletInitYPos, this, customCharData);
					bullets.add(newBullet);
				} else {
					newBullet = new BulletSprite(true, 'w', bulletInitXPos, bulletInitYPos, this, customCharData);
					bullets.add(newBullet);
					newBullet = new BulletSprite(true, 'p', bulletInitXPos, bulletInitYPos, this, customCharData);
					bullets.add(newBullet);
				}
			}
			
		} else {
			int bulletInitXPos;
			int bulletInitYPos;
			
			bulletInitXPos = player.getxPos();
			if(player.getFacing() == 'r')
				bulletInitXPos += 8;
			else
				bulletInitXPos -= 8;
			
			bulletInitYPos = player.getyPos() + 20;
			if(this.rain == null) {
				bulletInitYPos -= 13;
			}
			
			if(player.getCurrentPony() == PlayerSprite.TWILIGHT)
				bulletInitYPos -= 20;
			
			newBullet = new BulletSprite(true, player.getCurrentPony(), player.getFacing(), bulletInitXPos, bulletInitYPos, bulletImageManager, this);
		
		
			bullets.add(newBullet);
			
			if(player.getCurrentPony() == PlayerSprite.FLUTTERSHY) {
				switch(player.getFacing()) {
				case 'l':
					newBullet = new BulletSprite(true, player.getCurrentPony(), 'w', bulletInitXPos, bulletInitYPos, bulletImageManager, this);
					bullets.add(newBullet);
					newBullet = new BulletSprite(true, player.getCurrentPony(), 'p', bulletInitXPos, bulletInitYPos, bulletImageManager, this);
					bullets.add(newBullet);
					break;
				case 'r':
					newBullet = new BulletSprite(true, player.getCurrentPony(), 'e', bulletInitXPos, bulletInitYPos, bulletImageManager, this);
					bullets.add(newBullet);
					newBullet = new BulletSprite(true, player.getCurrentPony(), 's', bulletInitXPos, bulletInitYPos, bulletImageManager, this);
					bullets.add(newBullet);
					break;
				}
			}
		}
		
		lastBulletFireTimestamp = System.currentTimeMillis();
	}
	
	
	public void togglePauseGame() {
		isPaused = !isPaused;
	}
	
	public void exitGame() {
		shouldNotExit = false;
//		CustomImageDataIIRepository.flushLog();
	}
	
	public void newGame() {
		
		//System.out.println("Now in newGame...");
		
		if(gameRunning) {
			//System.out.println("newGame:  game is running.  Going to pop up the question panel.");
			boolean wasPaused = isPaused;
			isPaused = true;
			
			int result = JOptionPane.showConfirmDialog(null, "End this game and start a new one?", "Confirm Reset", JOptionPane.YES_NO_OPTION);
			
			if(result == JOptionPane.OK_OPTION || result == JOptionPane.YES_OPTION) {
				isPaused = false;
				gameRunning = true;
				resetGame();
			} else {
				isPaused = wasPaused;
			}
			
		} else {
			//System.out.println("newGame:  game is not running.  Going to reset the game.");
			resetGame();
			gameRunning = true;
			wasGameEverStarted = true;
		}
	}
	
	
	
	public void jumpWasReleased() {
		playerIsGoingUp = false;
	}
	
	public void leftWasReleased() {
		playerIsGoingLeft = false;
	}
	
	public void downWasReleased() {
		playerIsGoingDown = false;
	}
	
	public void rightWasReleased() {
		playerIsGoingRight = false;
	}
	
	public void fireWasReleased() {
		playerIsFiring = false;
	}
	
	public void enterWasReleased() {
		playerIsInteracting = false;
	}
	
	public void keyWasReleased(KeyEvent e) {
		
		if(e.getKeyCode() == KeyEvent.VK_UP) {
			jumpWasReleased();
		} else if(e.getKeyCode() == KeyEvent.VK_LEFT) {
			leftWasReleased();
		} else if(e.getKeyCode() == KeyEvent.VK_DOWN) {
			downWasReleased();
		} else if(e.getKeyCode() == KeyEvent.VK_RIGHT) {
			rightWasReleased();
		} else if(e.getKeyCode() == KeyEvent.VK_SPACE) {
			fireWasReleased();
		} else if(e.getKeyCode() == KeyEvent.VK_7) {
			Diagnostic.shouldDisplay = false;
		} else if(e.getKeyCode() == KeyEvent.VK_ENTER) {
			enterWasReleased();
		}
		
	}
	
	
	public PonyPanel(Container outsideContainer) {
		super();
		setFocusable(true);
		requestFocus();

		setKeysToDefault();
		
		
		FadingEnemySprite.initializeImages(this);
		
		enclosing = outsideContainer;
		
		totalTicksOfGameplay = 0;
				
//		audioManager = new AudioManager();
//		audioManager.loadDefaultSounds();
		
		startPrimingTime = System.currentTimeMillis();
		foregroundIsPrimed = false;
		
		
		player = new PlayerSprite(this);
		player.populateRaingear(this);
		player.populateNoRaingearOnlyImages(this);
		
		marquisSprites = new ArrayList<MarquisSprite>();
		
		currentForeground = new ForegroundImage();
		currentForeground.populateDummyBackground(this);
		

//		blockManager = new StaticBlockManager(true, "dummyBlocks.txt");
//		blockManager = new StaticBlockManager(1, "testBlocks.tile");
		blockManager = new StaticBlockManager(1, "/levelData/testRoom2.room", this, false);
		
		bgm = BackgroundMusic.getDefault();
		bgm.startFromBeginning();
		musicSwitchedOn = true;
		
		commentaryIsNotLocked = false;
		
		
//		bossSprite = new RainbowElementalSprite(400, 360, 360, 200, RainbowElementalSprite.SPAWN_SIX, this);
//		bossSprite = new RainbowElementalSprite(400, 360, 360, 200, RainbowElementalSprite.NO_SPAWNING, this);
		
//		RoomData mainRoom = new RoomData(0, "testRoom2.room");
//		loadRoom(mainRoom);
		
//		goalSprite = new GoalSprite(470, 340, this, false, true);
		
		currentRoom = new RoomData(0, "/levelData/testRoom3.room", null, this, false);
		

		CustomImageDataIIRepository.fireLoadingThreadsRoomOnly("testRoom1", false, this);
		CustomImageDataIIRepository.fireLoadingThreadsRoomOnly("ROOM NAME [testRoom1]", false, this);
		CustomImageDataIIRepository.fireLoadingThreadsRoomOnly("testRoom2", false, this);
		CustomImageDataIIRepository.fireLoadingThreadsRoomOnly("testRoom3", false, this);
		CustomImageDataIIRepository.fireLoadingThreadsRoomOnly("DUMMY!!!!", false, this);
		
		
		blocks = new ArrayList<SolidBlockSprite>();
		
		bulletImageManager = new BulletImageManager(this);
		itemImageManager = new ItemImageManager(this);
		
//		SolidBlockSprite dummyBlock = new SolidBlockSprite(false, "images/crateGIF.GIF", 70, 70, 100, 100, null, false);
//		blocks.add(dummyBlock);
//		
//		SolidBlockSprite dummyBlock2 = new SolidBlockSprite(false, "images/crateGIF.GIF", 70, 70, 600, 300, null, false);
//		blocks.add(dummyBlock2);
//		
//		SolidBlockSprite dummyBlock3 = new SolidBlockSprite(false, "images/passRogue.GIF", 70, 70, 1600, 400, Color.green, true);
//		blocks.add(dummyBlock3);
//		
//		
//		MovingBlockSprite movingBlock1 = new MovingBlockSprite(false, "images/crateGIF.GIF", 70, 70, 3000, 400, null, false, MovingBlockSprite.MOVE_MODE_EAST_WEST, 2800, 3200, 'l', 4);
//		blocks.add(movingBlock1);
		
		
		loadingAnimation = new CustomImageDataII[19];
		
		for(int i = 0; i < 19; i++) {
			
			loadingAnimation[i] = new CustomImageDataII("/images/present load " + (i + 1) + ".GIF", Color.white, this);
			
		}
		
		
		
		
		
		this.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				keyWasPressed(e);
			}
			public void keyReleased(KeyEvent e) {
				keyWasReleased(e);
			}
		});
		
		
		/*this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "leftWasPressed");
		Action leftWasPressed = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				leftWasPressed();
			}
		};
		this.getActionMap().put("leftWasPressed", leftWasPressed);
		

		this.getInputMap().put(KeyStroke.getKeyStroke("released LEFT"), "leftWasReleased");
		Action leftWasReleased = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				leftWasReleased();
			}
		};
		this.getActionMap().put("leftWasReleased", leftWasReleased);
		
		
		
		this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "upWasPressed");
		Action upWasPressed = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				upWasPressed();
			}
		};
		this.getActionMap().put("upWasPressed", upWasPressed);

		this.getInputMap().put(KeyStroke.getKeyStroke("released UP"), "upWasReleased");
		Action upWasReleased = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				upWasReleased();
			}
		};
		this.getActionMap().put("upWasReleased", upWasReleased);
		
		
		
		this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "rightWasPressed");
		Action rightWasPressed = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				rightWasPressed();
			}
		};
		this.getActionMap().put("rightWasPressed", rightWasPressed);

		this.getInputMap().put(KeyStroke.getKeyStroke("released RIGHT"), "rightWasReleased");
		Action rightWasReleased = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				rightWasReleased();
			}
		};
		this.getActionMap().put("rightWasReleased", rightWasReleased);
		
		
		
		this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "downWasPressed");
		Action downWasPressed = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				downWasPressed();
			}
		};
		this.getActionMap().put("downWasPressed", downWasPressed);

		this.getInputMap().put(KeyStroke.getKeyStroke("released DOWN"), "downWasReleased");
		Action downWasReleased = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				downWasReleased();
			}
		};
		this.getActionMap().put("downWasReleased", downWasReleased);
		
		
		
		this.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "spaceWasPressed");
		Action spaceWasPressed = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				spaceWasPressed();
			}
		};
		this.getActionMap().put("spaceWasPressed", spaceWasPressed);

		this.getInputMap().put(KeyStroke.getKeyStroke("released SPACE"), "spaceWasReleased");
		Action spaceWasReleased = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				spaceWasReleased();
			}
		};
		this.getActionMap().put("spaceWasReleased", spaceWasReleased);
		
		
		
		this.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "escapeWasPressed");
		Action escapeWasPressed = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				escapeWasPressed();
			}
		};
		this.getActionMap().put("escapeWasPressed", escapeWasPressed);*/

		/*this.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "escapeWasReleased");
		Action escapeWasReleased = new AbstractAction() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				escapeWasReleased();
			}
		};
		this.getActionMap().put("escapeWasReleased", escapeWasReleased);*/
		
		
		//setUpControllerListenerStuff();
		

		enemyImageManager = new EnemyImageManager(this);
		
		enemies = new ArrayList<EnemySprite>();
		
//		EnemySprite enemyTester = new EnemySprite();
//		enemyTester.popupate(100, 100, EnemySprite.UP_DOWN_TURRET, 50, 150, 'l', enemyImageManager, this);
//		enemies.add(enemyTester);
//		
//		enemyTester = new EnemySprite();
//		enemyTester.popupate(100, 200, EnemySprite.STATIONARY, 0, 0, 'l', enemyImageManager, this);
//		enemies.add(enemyTester);
		
		rain = new RainSprite(new Color(50, 100, 200));//Color.cyan
		
		
//		
//		enemyTester = new EnemySprite();
//		enemyTester.popupate(200, 100, EnemySprite.UP_DOWN_TURRET, 150, 250, 'l', enemyImageManager, this);
//		enemies.add(enemyTester);
//		
//		enemyTester = new EnemySprite();
//		enemyTester.popupate(200, 200, EnemySprite.TURRET, 150, 250, 'u', enemyImageManager, this);
//		enemies.add(enemyTester);
//		
//		enemyTester = new EnemySprite();
//		enemyTester.popupate(300, 100, EnemySprite.UP_DOWN_TURRET, 50, 150, 'u', enemyImageManager, this);
//		enemies.add(enemyTester);
//		
//		enemyTester = new EnemySprite();
//		enemyTester.popupate(300, 200, EnemySprite.TURRET, 0, 0, 'l', enemyImageManager, this);
//		enemies.add(enemyTester);
//		
//		enemyTester = new EnemySprite();
//		enemyTester.popupate(400, 100, EnemySprite.TURRET, 350, 450, 'r', enemyImageManager, this);
//		enemies.add(enemyTester);
//		
//		enemyTester = new EnemySprite();
//		enemyTester.popupate(400, 200, EnemySprite.TURRET, 350, 450, 'l', enemyImageManager, this);
//		enemies.add(enemyTester);
		
		
		
		
		
		
		
		
		
//		EnemySprite testEnemy = new EnemySprite();
//		testEnemy.populateDummy(450, 150);
//		enemies.add(testEnemy);	
//		
//		EnemySprite testEnemy2 = new EnemySprite();
//		testEnemy2.populateDummy(600, 200);
//		enemies.add(testEnemy2);
		
//		EnemySprite testEnemy3 = new EnemySprite();
//		testEnemy3.populateDummy(600, 100);
//		enemies.add(testEnemy3);
//		
//		EnemySprite testEnemy4 = new EnemySprite();
//		testEnemy4.populateDummy(1600, 50);
//		enemies.add(testEnemy4);
//		
//		EnemySprite testEnemy5 = new EnemySprite();
//		testEnemy5.populateDummy(2200, 250);
//		enemies.add(testEnemy5);
//		
//		EnemySprite testEnemy6 = new EnemySprite();
//		testEnemy6.populateDummy(2600, 100);
//		enemies.add(testEnemy6);
//		
//		EnemySprite testEnemy7 = new EnemySprite();
//		testEnemy7.populateDummy(85 * 40, 300);
//		enemies.add(testEnemy7);
//		
//		EnemySprite testEnemy8 = new EnemySprite();
//		testEnemy8.populateDummy(95 * 40, 250);
//		enemies.add(testEnemy8);
//		
//		EnemySprite testEnemy9 = new EnemySprite();
//		testEnemy9.populateDummy(95 * 40, 100);
//		enemies.add(testEnemy9);
//		
		doors = new ArrayList<DoorSprite>();
		bullets = new ArrayList<BulletSprite>();
		fadingEnemies = new ArrayList<FadingEnemySprite>();
		items = new ArrayList<ItemSprite>();
		enemyBullets = new ArrayList<BulletSprite>();
		commentDoors = new ArrayList<DoorSprite>();
		
//		items.add(new ItemSprite(ItemSprite.HEART, 0, 0, itemImageManager));
//		items.add(new ItemSprite(ItemSprite.HEART, -300, 0, itemImageManager));
//		items.add(new ItemSprite(ItemSprite.HEART, -300, -100, itemImageManager));
//		items.add(new ItemSprite(ItemSprite.HEART, -300, -150, itemImageManager));
//		items.add(new ItemSprite(ItemSprite.HEART, -300, -200, itemImageManager));
//		items.add(new ItemSprite(ItemSprite.HEART, -300, -250, itemImageManager));
//		
//		items.add(new ItemSprite(ItemSprite.HEART, 0, 700, itemImageManager));
//		
//		items.add(new ItemSprite(ItemSprite.HEART, 700, 700, itemImageManager));
//		items.add(new ItemSprite(ItemSprite.HEART, 700, 0, itemImageManager));
		
		//dummyLevel = new LevelData("testLevel.lvl", this, false);
		
		
//		String conveyorAnim[] = {
//				"/images/conveyor1.GIF",
//				"/images/conveyor2.GIF",
//				"/images/conveyor3.GIF",
//			"/images/conveyor4.GIF"	
//		};
//		Color conveyorCol[] = {Color.white,Color.white,Color.white,Color.white};
//		
//		ConveyorBlockSprite conveyor = new ConveyorBlockSprite(true, 200, 20, 200, 300, false, this, 6, 'l', conveyorAnim, conveyorCol, "dummyLevel");
//		blocks.add(conveyor);
		
		
//		playerRespawnRoom = dummyLevel.getRoom(dummyLevel.getLevelStartRoomName());
//		playerRespawnX = dummyLevel.getLevelStartX();
//		playerRespawnY = dummyLevel.getLevelStartY();
		
		
		
		tutorialLevel = new LevelData("/levelData/tutorial.lvl", this, false);
		
		try {
//		mainLevel = new LevelData("weatherfactory resource", this, false);
			mainLevel = LevelData.loadLevelThreaded("/levelData/weatherfactory resource", this, false);
		} catch(Exception e) {
//			e.printStackTrace();
			
			System.exit(1);
		}
		
		
		
		
		playerRespawnRoom = tutorialLevel.getRoom(tutorialLevel.getLevelStartRoomName());
		playerRespawnX = tutorialLevel.getLevelStartX();
		playerRespawnY = tutorialLevel.getLevelStartY();
		
		roomWhereBossWasKilled = null;
		
		foregroundWidgets = new ArrayList<WidgetSprite>();
		backgroundWidgets = new ArrayList<WidgetSprite>();
		commentWidgets = new ArrayList<WidgetSprite>();
		
//		RoomData rd = dummyLevel.getRoom("testRoom2");
//		if(rd != null) {
//			StaticBlockManager sbm = rd.getBlockManager();
//			if(sbm != null) {
//				sbm.printAllColumnSizes();
//			}
//		}
		
//		ImageIcon tempImage = new ImageIcon(PonyPanel.class.getResource("images/menu_tut.GIF"));
//		menuImage = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
		menuImage = new CustomImageDataII("/images/menu_resume_options_keys_help.BMP", null, this);
				
//		tempImage = new ImageIcon(PonyPanel.class.getResource("images/menu_tut_noresume.GIF"));
//		menuImageNoResume = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
		menuImageNoResume = new CustomImageDataII("/images/menu_noresume_options_keys_help.BMP", null, this);
		
		quickKeyReferenceImage = new CustomImageDataII("/images/quick key reference.GIF", null, this);
		
		
		
		optionsMenuBothOffImage = new CustomImageDataII("/images/options_both_off.GIF", null, this);
		optionsMenuBothOnImage = new CustomImageDataII("/images/options_both_on.GIF", null, this);
		optionsMenuMusicOnImage = new CustomImageDataII("/images/options_music_on.GIF", null, this);
		optionsMenuCommentaryOnImage = new CustomImageDataII("/images/options_commentary_on.GIF", null, this);
		optionsMenuLockedOnImage = new CustomImageDataII("/images/options_locked_on.GIF", null, this);
		optionsMenuLockedOffImage = new CustomImageDataII("/images/options_locked_off.GIF", null, this);
		
		commentaryEnabledImage = new CustomImageDataII("/images/commentary enabled.GIF", null, this);
		
		
//		tempImage = new ImageIcon(PonyPanel.class.getResource("images/menu_beaten.GIF"));
//		beatenMenuImage = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
//		beatenMenuImage = new CustomImageDataII("/images/menu_beaten.GIF", null, this);
		
//		tempImage = new ImageIcon(PonyPanel.class.getResource("images/menu_beaten_noresume.GIF"));
//		beatenMenuImageNoResume = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
//		beatenMenuImageNoResume = new CustomImageDataII("/images/menu_beaten_noresume.GIF", null, this);
		
//		tempImage = new ImageIcon(PonyPanel.class.getResource("images/exit_confirm.GIF"));
//		confirmExitMenuImage = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
		confirmExitMenuImage = new CustomImageDataII("/images/exit_confirm.GIF", null, this);
		
		saveOrExitMenuImage = new CustomImageDataII("/images/save_or_exit.GIF", null, this);
		
//		tempImage = new ImageIcon(PonyPanel.class.getResource("images/new_confirm.GIF"));
//		confirmNewMenuImage = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
		confirmNewMenuImage = new CustomImageDataII("/images/new_confirm.GIF", null, this);
		
		
		
//		tempImage = new ImageIcon(PonyPanel.class.getResource("images/about.GIF"));
//		aboutImage = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
		aboutImage = new CustomImageDataII("/images/about2.GIF", null, this);
		
//		tempImage = new ImageIcon(PonyPanel.class.getResource("images/story.GIF"));
//		storyImage = new CustomImageDataII(tempImage.getImage(), tempImage.getIconWidth(), tempImage.getIconHeight(), null, this);
		storyImage = new CustomImageDataII("/images/story2.GIF", null, this);
		
		adventureLoadTutorialMenuImage = new CustomImageDataII("/images/new_or_load_or_tutorial.GIF", null, this);
		
		
		
		customNpcs = new ArrayList<CustomNpc>();
//		CustomNpcBehavior dummyBehav = CustomNpcBehavior.getDummyEvilSmiley(this);
//		customNpcs.add(new CustomNpc(dummyBehav, 80,80, 40,40));
		
		
		
		radios = new ArrayList<RadioSprite>();
		
//		try {
//			RadioSprite radio = new RadioSprite(200, 150, "/sounds/radiotest.wav", false, this);
//			radios.add(radio);
//		} catch(Exception e) {
//			e.printStackTrace();
//		}
		
		
		hurtzones = new ArrayList<HurtzoneSprite>();
		
//		HurtzoneSprite hz1 = new HurtzoneSprite(350, 200, false, 300, 550, 3000, 5000, 1, 1, 2000, 1, 0.75, 0.9999);
//		hurtzones.add(hz1);
//		
//		HurtzoneSprite hz2 = new HurtzoneSprite(150, 200, true, 175, 250, 2000, 5000, 1, 1, 1000, 3, 0.15, 0.25);
//		hurtzones.add(hz2);
		
		
		loadRoom(tutorialLevel.getRoom(tutorialLevel.getLevelStartRoomName()), tutorialLevel.getLevelStartX(), tutorialLevel.getLevelStartY(), false);
		
		
		if(canvasBuffer == null) {
//			canvasBuffer = createImage(PLAY_AREA_WIDTH, PANEL_HEIGHT);
			canvasBuffer = createCanvasBuffer(PLAY_AREA_WIDTH, PANEL_HEIGHT + 112);
			if(canvasBuffer == null) {
				//System.err.println("ERROR:  canvasBuffer was null");
				return;
			} else {
//				canvasGraphics = canvasBuffer.getGraphics();
				canvasGraphics = canvasBuffer.createGraphics();
			}
		}
		
		if(canvasGraphics != null) {
			
//			boxManager.ensureArraysAreDisplayable(canvasGraphics);
//			thePlayer.ensureArraysAreDisplayable(canvasGraphics);
//			itemManager.ensureArraysAreDisplayable(canvasGraphics);
//			theBomb.ensureArraysAreInitialized(canvasGraphics);
			
		} else {
			//System.out.println("vvvvvvv ACK!  canvasGraphics was null!");
		}
		
		
	}
	
	
	
	
	public void run() {
		
		try {
			
			long beforeTime = System.nanoTime();
			long afterTime;
			
			boolean alreadyDidIt = false;
			boolean imagesPrimed = false;
			
			long startTime = System.currentTimeMillis();
			
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
			
			while(shouldNotExit) {
				
				alreadyDidPink3 = false;
				alreadyDidPink4 = false;
				
				
				if(!imagesPrimed && canvasGraphics != null) {
					blockManager.primeAllImages(canvasGraphics);
					imagesPrimed = true;
				}
				
	//			//System.out.println("about to call updateElements...");
				
				if(startPrimingTime + 2500L <= System.currentTimeMillis()) {
					this.updateElements();
				}
	//			//System.out.println("about to call gameDraw...");
				
				
				this.gameDraw();
	//			//System.out.println("about to call repaint...");
				
				

//				repaint();
				this.paintImmediately(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT + 112);
				
	//			//System.out.println("about to call Thread.sleep...");
				
				afterTime = System.nanoTime();
				
				if(afterTime - beforeTime < TICK_LENGTH_NANO) {
					try {
						Thread.sleep((TICK_LENGTH_NANO - (afterTime - beforeTime)) / 1000000L);
					}catch (Exception e) {
	//					e.printStackTrace();
						//System.out.println("big fat error!");
						shouldNotExit = false;
					}
				}
				
				beforeTime = System.nanoTime();
				
				
				if(!alreadyDidIt) {
					if(System.currentTimeMillis() > startTime + 100L) {
						alreadyDidIt = true;
						currentForeground.setForeground(blockManager.drawTheWholeImage(this));//, Color.magenta
					}
				}
				
				
	//			Color transparentBlack = new Color(255,0,0,0);
	//			int transparentBlackRGB = transparentBlack.getRGB();
	//			Color opaqueBlack = new Color(255,0,0,255);
	//			int opaqueBlackRGB = opaqueBlack.getRGB();
	//			
	//			//System.out.println("//////////////////////   transparentBlackRGB: " + transparentBlackRGB + ", opaqueBlackRGB: " + opaqueBlackRGB);
				
				
			}
		} catch(Throwable t) {
			String traceRaw = formatStackTrace(t);
			
			traceRaw = traceRaw.replace("\n", "<br>");
			JOptionPane.showMessageDialog(null, "<html>An error occurred in the main panel's run method:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
			
			System.exit(1);
		}
		
		//System.out.println("got to the end of the run method!");
		
		System.exit(0);
	}
	
	public void gameStart() {
		
		shouldNotExit = true;
		
		theGame = new Thread(this);
		theGame.start();
		
		BusyPanel.hideWaitBox();
		
	}
	
	public void windowWasClosed() {
		shouldNotExit = false;
	}
	
	
	
	public void reactiveControllerPanelDone() {
		
		isPaused = false;
		
	}
	
	public int calculateProperStep(int rawStep, float controllerDownness) {
		
		return (int) (rawStep * controllerDownness + 0.5f);
		
	}
	
	public static String formatStackTrace(Throwable t) {
		
		StringBuffer returnValue = new StringBuffer();

		returnValue.append("kind of error:  " + t.getClass().getCanonicalName() + "\n");
		returnValue.append("message:  " + t.getMessage() + "\n");
		returnValue.append("localized message:  " + t.getLocalizedMessage() + "\n");
		
		
		StackTraceElement array[] = t.getStackTrace();
		
		for(int i = 0; i < array.length; i++) {
			returnValue.append(array[i].getClassName() + "." + array[i].getMethodName() + ": " + array[i].getLineNumber() + "\n");
		}
		
		
		return returnValue.toString();
	}
	
	
	public static String formatStackTrace(StackTraceElement array[]) {
		
		StringBuffer returnValue = new StringBuffer();

//		returnValue.append("kind of error:  " + t.getClass().getCanonicalName() + "\n");
//		returnValue.append("message:  " + t.getMessage() + "\n");
//		returnValue.append("localized message:  " + t.getLocalizedMessage() + "\n");
		
		
		for(int i = 0; i < array.length; i++) {
			returnValue.append(array[i].getClassName() + "." + array[i].getMethodName() + ": " + array[i].getLineNumber() + "\n");
		}
		
		
		return returnValue.toString();
	}
	
	
	
	
	

	public void resetGame() {
		
		//initialize box positions
		
		
	}
	
	
	public Clip loadGivenClip(String fileName) {
		
		Clip returnValue = null;
		
		AudioInputStream ais;
		try {
			ais = AudioSystem.getAudioInputStream(new File(fileName));
			AudioFormat af = ais.getFormat();
			
			if(af.getEncoding() == AudioFormat.Encoding.ALAW ||
					af.getEncoding() == AudioFormat.Encoding.ULAW ) {
				
				AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED,
						af.getSampleRate(),
						af.getSampleSizeInBits() * 2,
						af.getChannels(),
						af.getFrameSize() * 2,
						af.getFrameRate(),
						true);
				
				ais = AudioSystem.getAudioInputStream(newFormat, ais);
				af = newFormat;
				
			}
			
			DataLine.Info inf = new DataLine.Info(Clip.class, af);
			
			if(!AudioSystem.isLineSupported(inf)) {
				JOptionPane.showMessageDialog(null, "ERROR:  The clip isn't supported!");
			}
			
			returnValue = (Clip) AudioSystem.getLine(inf);
			returnValue.open(ais);
			ais.close();
			
		} catch (UnsupportedAudioFileException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			return null;
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			return null;
		} catch (LineUnavailableException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			return null;
		}
		
		return returnValue;
	}
	
//	public AudioClip loadGivenMidi(String fileName) {
//		
//		gameOverSound = null;
//		
//		
//		AudioClip returnValue = null;
//		
//		File file = new File(fileName);
//		
//		try {
//			URL url = file.toURI().toURL();
//			returnValue = Applet.newAudioClip(url);
//		} catch (MalformedURLException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//			return null;
//		}
//		
//		
//		return returnValue;
//		
//	}
	
	
	
	private void titleScreenDraw() {
		
		////System.out.println("now in titleScreenDraw");
		
		if(gameRunning || wasGameEverStarted) {
			return;
		}
		
		
	}
	
//	public void loadOverlayImages(BufferedReader in) throws IOException {
//		
//		String inputter = in.readLine();
//		
//		int countOfFrames = Integer.parseInt(inputter);
//		
//		overlayImages = new CustomImageDataII[countOfFrames];
//		
//		int tempWidth, tempHeight, tempAlpha;
//		
//		String tempFileName;
//		Color tempColor;
//		
//		ImageIcon tempIcon = null;
//		
//		for(int i = 0; i < countOfFrames; i++) {
//			
//			tempFileName = in.readLine();
//			tempIcon = new ImageIcon((tempFileName));
//			inputter = in.readLine();
//			tempColor = translateFileInStringToColor(inputter);
//			inputter = in.readLine();
//			tempWidth = Integer.parseInt(inputter);
//			inputter = in.readLine();
//			tempHeight = Integer.parseInt(inputter);
//			inputter = in.readLine();
//			tempAlpha = Integer.parseInt(inputter);
//			
//			overlayImages[i] = new CustomImageDataII(
//					CustomImageDataII.makeImageMoreTransparentOf255(tempIcon.getImage(), tempAlpha),
//					tempWidth,
//					tempHeight, 
//					tempColor,
//					this);
//			
//			
//		}
//		
//	}
	
	public Color translateFileInStringToColor(String inputter) {
		
		String split[] = inputter.split(":");
		
		int red = Integer.parseInt(split[0]);
		int green = Integer.parseInt(split[1]);
		int blue = Integer.parseInt(split[2]);
		
		return new Color(red, green, blue);
	}
	
	public void setKeysToDefault() {
		
		//System.out.println("now in setKeysToDefault");
		
		upKey = KeyEvent.VK_UP;
		downKey = KeyEvent.VK_DOWN;
		leftKey = KeyEvent.VK_LEFT;
		rightKey = KeyEvent.VK_RIGHT;
		snagKey = KeyEvent.VK_SPACE;
		bombKey = KeyEvent.VK_CONTROL;
		netKey = KeyEvent.VK_SHIFT;
		newGameKey = KeyEvent.VK_F2;
		pauseKey = KeyEvent.VK_F3;
		exitKey = KeyEvent.VK_ESCAPE;
		
	}
	/*
	public void keyWasPressedII(KeyEvent e) {
		
		if(e.getKeyCode() == upKey) {
			playerIsGoingUp = true;
		} else if(e.getKeyCode() == leftKey) {
			playerIsGoingLeft = true;
		} else if(e.getKeyCode() == downKey) {
			playerIsGoingDown = true;
		} else if(e.getKeyCode() == rightKey) {
			playerIsGoingRight = true;
		} else if(e.getKeyCode() == snagKey) {
			
			playerIsFiring = true;
			
//			if(thePlayer.getSnagRadius() > PlayerSprite.MIN_SNAG_RADIUS ||
//					thePlayer.playerIsGoingOut()) {
//				//do nothing
//			} else {
//				thePlayer.setGoingOut(true);
//			}
		} else if(e.getKeyCode() == exitKey) {
			exitGame();
		} else if(e.getKeyCode() == pauseKey) {
			togglePauseGame();
		} else if(e.getKeyCode() == bombKey) {
			
			isBombing = true;
			
//			//System.out.println("control press detected.");
//			if(bombsRemaining > 0 && !theBomb.isActive()) {
//				//System.out.println("it should have planted a bomb by now...");
//				bombsRemaining--;
//				theBomb.setActive(true);
//			}
		} else if(e.getKeyCode() == netKey) {
			isNetting = true;
		} else if(e.getKeyCode() == newGameKey) {
			newGame();
			
		} 
		
	}
	
	public void keyWasReleasedII(KeyEvent e) {
		
		if(e.getKeyCode() == upKey) {
			playerIsGoingUp = false;
		} else if(e.getKeyCode() == leftKey) {
			playerIsGoingLeft = false;
		} else if(e.getKeyCode() == downKey) {
			playerIsGoingDown = false;
		} else if(e.getKeyCode() == rightKey) {
			playerIsGoingRight = false;
		} else if(e.getKeyCode() == snagKey) {
			playerIsFiring = false;
		} else if(e.getKeyCode() == bombKey) {
			isBombing = false;
		} else if(e.getKeyCode() == netKey) {
			isNetting = false;
		}
		
	}
	*/
	public void setKeysFromHashMap(HashMap<String, Integer> keyMap) {
		
		upKey = keyMap.get("up");
		leftKey = keyMap.get("left");
		rightKey = keyMap.get("right");
		downKey = keyMap.get("down");
		snagKey = keyMap.get("snag");
		bombKey = keyMap.get("bomb");
		netKey = keyMap.get("net");
		newGameKey = keyMap.get("new");
		pauseKey = keyMap.get("pause");
		exitKey = keyMap.get("exit");
		
		
	}
	
	public HashMap<String, Integer> getKeysInHashMap() {
		
		HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
		
		returnValue.put("up", this.upKey);
		returnValue.put("left", this.leftKey);
		returnValue.put("right", this.rightKey);
		returnValue.put("down", this.downKey);
		returnValue.put("snag", this.snagKey);
		returnValue.put("bomb", this.bombKey);
		returnValue.put("net", this.netKey);
		returnValue.put("new", this.newGameKey);
		returnValue.put("pause", this.pauseKey);
		returnValue.put("exit", this.exitKey);
		
		return returnValue;
	}
	
	public void ensurePauseGame() {
		isPaused = true;
	}
	
	public void ensureUnPauseGame() {
		isPaused = false;
	}
	
	public boolean isPaused() {
		return isPaused;
	}
	
	public void loadHelpText(BufferedReader in) throws IOException {
		
		StringBuffer rawHelpText = new StringBuffer();
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			rawHelpText.append(inputter);
			rawHelpText.append("\n");
		}
		
		helpText = rawHelpText.toString();
		
	}
	
	
	public void setHelpWindowToNull() {
		helpFrame = null;
	}
	
	public boolean loadMethodMayHavePause() {
		return loadMethodMayHavePause;
	}

	public void setLoadMethodMayHavePause(boolean loadMethodMayHavePause) {
		this.loadMethodMayHavePause = loadMethodMayHavePause;
	}

	public boolean loadMethodWantsPause() {
		return loadMethodWantsPause;
	}

	public void setLoadMethodWantsPause(boolean loadMethodWantsPause) {
		this.loadMethodWantsPause = loadMethodWantsPause;
	}

	public PipedInputStream getWaitMechanismIn() {
		return waitMechanismIn;
	}

	public void setWaitMechanismIn(PipedInputStream waitMechanism) {
		this.waitMechanismIn = waitMechanism;
	}
	
	private int getNormalEndScoreThreshold() {
		return (startingLevel - 1) * 50 + 1000;
	}
	
	private int getGoodEndScoreThreshold() {
		return (startingLevel - 1) * 100 + 2000;
	}
	
	public void setStartingLevel(int newStartingLevel) {
		startingLevel = newStartingLevel;
	}
	
	public void primeAllImagesExceptTheForeground() {
		
		if(canvasGraphics == null) {
			//System.err.println("unable to prime images; canvasGraphics was null!");
			return;
		}
		
		player.primeAllImages(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
		for(BlockInterface block : blocks) {
			block.primeImage(canvasGraphics);
		}
		
		blockManager.primeAllImages(canvasGraphics);
		
		for(EnemySprite enemy : enemies) {
			enemy.primeAllImages(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		}
		
		FadingEnemySprite.primeImages(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
//		currentForeground.setForeground(new ImageIcon(blockManager.drawTheWholeImage(this, Color.magenta)));
		currentForeground.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
		currentRoom.primeAll(canvasGraphics);
		
		bulletImageManager.primeAll(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
		dummyLevel.primeAll(canvasGraphics);
		
		if(bossSprite != null) {
			bossSprite.primeImages(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		}
		
		if(enemyImageManager != null)
			enemyImageManager.primeAllImages(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
//		if(menuImage != null)
//			menuImage.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
//		
//		if(beatenMenuImage != null)
//			beatenMenuImage.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
//		
//		if(confirmExitMenuImage != null)
//			confirmExitMenuImage.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
//		
//		if(confirmNewMenuImage != null)
//			confirmNewMenuImage.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
//		
//		if(menuImageNoResume != null)
//			menuImageNoResume.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
//		
//		if(beatenMenuImageNoResume != null)
//			beatenMenuImageNoResume.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
	}
	
	public void primeForeground() {
		
		if(!foregroundIsPrimed) {
			currentForeground.setForeground(blockManager.drawTheWholeImage(this));//, Color.magenta
			foregroundIsPrimed = true;
		}
		
		currentForeground.primeImage(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
	}
	
//	public void populateTilesFromResource(String file) {
//		blockManager = new StaticBlockManager(true, fileToLoad)
//	}
	
	public void loadRoom(RoomData room, int playerX, int playerY, boolean shouldOmitCheckpoints) {
		
//		System.out.println("<><>DELME at the start of loadRoom...is it null? " + (room == null));
		
		room.getParent().manageAudioLoading(room.getRoomName());
		
		try {
			loadProgress = 0.0;
			
			if(lastRoomLoaded == null || !lastRoomLoaded.equals(room.getRoomName())) {
				//System.out.println("inside loadRoom's initial if-block...");
				CustomImageDataIIRepository.fireLoadingThreads(room, isFromFiles, this);
				//System.out.println("after loadingThreads...");
				CustomImageDataIIRepository.firePurgeThread(room, this);
				//System.out.println("after firePurgeThread...");
				lastRoomLoaded = room.getRoomName();
			}
			
			//System.out.println("after loadRoom's initial if-block...");
			
			
			if(!CustomImageDataIIRepository.areAllImagesReadyForRoom(room.getRoomName())) {
				isLoading = true;
				loadProgress = CustomImageDataIIRepository.getRoomProgress(room.getRoomName());
	//			if(loadProgress == 1.0) {
	//				if(!CustomImageDataIIRepository.areAllImagesReadyForRoom(room.getRoomName())) {
	//					//System.err.println("Error:  it says the load progress is complete for room " + room.getRoomName() + ", but it's not!");
	//					CustomImageDataIIRepository.fireLoadingThreads(room, isFromFiles);
	//					lastRoomLoaded = room.getRoomName();
	//					//System.out.println("returning from loadRoom...");
	//					return;
	//				}
	//			}
				
				
				long waitStartTime = System.currentTimeMillis();
				
				while(!CustomImageDataIIRepository.areAllImagesReadyForRoom(room.getRoomName())) {
					
//					alreadyDidPink4 = false;
//					
					this.gameDraw();
//					
//
//					if(isLoading && !roomIsntEvenLoaded) {
//						System.out.println("<><>DELME pink pink pink4");
//						Color origCol = canvasBuffer.getGraphics().getColor();
//						canvasBuffer.getGraphics().setColor(Color.PINK);
//						canvasBuffer.getGraphics().drawRect(10, 10, 20, 20);
//						canvasBuffer.getGraphics().setColor(origCol);
//						
//						alreadyDidPink4 = true;
//						
//						if(alreadyDidPink3) {
//							System.out.println("<><>DELME already did pink 3");
//						}
//						
//					}
//					
//					
//					this.repaint();
					this.paintImmediately(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT + 112);
					
					try {
						Thread.sleep(100L);
					} catch(Exception e) {
	//					e.printStackTrace();
						break;
					}
					
					if(waitStartTime + 5000L < System.currentTimeMillis()) {
						//System.err.println("this is taking too long!  Gonna start her up again...the alleged progress is: " + CustomImageDataIIRepository.getRoomProgress(room.getRoomName()));
						CustomImageDataIIRepository.fireLoadingThreadsRoomOnly(room.getRoomName(), isFromFiles, this);
					}
					
					loadProgress = CustomImageDataIIRepository.getRoomProgress(room.getRoomName());
					
				}
				
				
				
			}
			
			
			
			
			
			
			if(radios != null) {
				for(RadioSprite r : radios) {
					r.stopAudio();
				}
			}
			
			
			//System.out.println("<><>DELME now in loadRoom!  is room null?  " + (room == null));
			
			goalSprite = null;
			bossSprite = null;
			
			if(bullets != null)
				bullets.clear();
			bullets = new ArrayList<BulletSprite>();
			
			if(enemyBullets != null)
				enemyBullets.clear();
			enemyBullets = new ArrayList<BulletSprite>();
			
			currentRoom = room;
			blockManager = room.getBlockManager();
			blocks = room.getRogueBlocks();
			backgroundColor = room.getBackgroundColor();
			
	//		if(playerX == Integer.MIN_VALUE)
	//			player.setxPos(room.getPlayerSpawnPointX());
	//		else
				player.setxPos(playerX);
			
	//		if(playerY == Integer.MIN_VALUE)
	//			player.setyPos(room.getPlayerSpawnPointY());
	//		else
				player.setyPos(playerY);
			
			//need to spawn enemies
			ArrayList<EnemySpawnPoint> enemySpawnPoints = room.getEnemySpawnPoints();
			
			//System.out.println("<><>DELME size of enemySpawnPoints: " + enemySpawnPoints.size());
			
			enemies = new ArrayList<EnemySprite>();
			EnemySprite tempEnemy = null;
			
			for(EnemySpawnPoint p : enemySpawnPoints) {
				
				tempEnemy = new EnemySprite();
				
				switch(p.getBehavior()) {
				case EnemySprite.STATIONARY:
				case EnemySprite.TURRET:
				default:
					tempEnemy.popupate(p.getxPos(), p.getyPos(), p.getBehavior(), -1, -1, p.getDir(), enemyImageManager, this);
					break;
				case EnemySprite.LEFT_RIGHT:
				case EnemySprite.LIGHTNING:
					tempEnemy.popupate(p.getxPos(), p.getyPos(), p.getBehavior(), p.getMinX(), p.getMaxX(), p.getDir(), enemyImageManager, this);
					break;
				case EnemySprite.UP_DOWN:
				case EnemySprite.UP_DOWN_TURRET:
					tempEnemy.popupate(p.getxPos(), p.getyPos(), p.getBehavior(), p.getMinY(), p.getMaxY(), p.getDir(), enemyImageManager, this);
					break;
				}
				
				if(canvasGraphics != null)
					tempEnemy.primeAllImages(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				enemies.add(tempEnemy);
			}
			
			//System.out.println("<><>DELME size of enemies: " + enemies.size());
			
			customNpcs = new ArrayList<CustomNpc>();
			
			//System.out.println("<><>DELME size of blockManager: " + blockManager.getTotalWidth() + " by " + blockManager.getTotalHeight());
	//		blockManager.printAllColumnSizes();
	
			blockManager.primeAllImages(canvasGraphics);
			
			BufferedImage wholeForground = blockManager.drawTheWholeImage(this);//, Color.magenta
			
			doors = room.getDoors();
			commentDoors = room.getCommentDoors();
			
			if(wholeForground != null)
				currentForeground.setForeground(wholeForground);
			
			items = new ArrayList<ItemSprite>();
			
			ArrayList<ItemSpawnPoint> itemSpawnPoints = room.getItemSpawnPoints();
			if(itemSpawnPoints != null && itemSpawnPoints.size() > 0) {
				ItemSpawnPoint tempIsp = null;
				ItemSprite newItem = null;
				for(int i = 0; i < itemSpawnPoints.size(); i++) {
					
					tempIsp = itemSpawnPoints.get(i);
					
					if(shouldOmitCheckpoints && tempIsp.getType() == ItemSprite.CHECKPOINT_FLAG)
						continue;
					
					newItem = new ItemSprite(tempIsp.getType(), tempIsp.getX(), tempIsp.getY(), itemImageManager);
					items.add(newItem);
					
				}
			}
			
			bossSprite = null;
			if(roomWhereBossWasKilled == null 
					|| this.currentRoom == null 
					|| this.currentRoom.getRoomName() == null 
					|| !this.currentRoom.getRoomName().equals(roomWhereBossWasKilled)) {
				BossSpawnPoint bossSpawnPoint = room.getBossSpawnPoint();
				if(bossSpawnPoint != null) {
					
					bossSprite = new RainbowElementalSprite(bossSpawnPoint.getxPos(), bossSpawnPoint.getyPos(), bossSpawnPoint.getxFlagSpawn(), bossSpawnPoint.getyFlagSpawn(), bossSpawnPoint.getKind(), this);
					bossSprite.primeImages(canvasGraphics, PLAY_AREA_WIDTH, PANEL_HEIGHT);
				}
			}
			
			foregroundWidgets = room.getForegroundWidgets();
			backgroundWidgets = room.getBackgroundWidgets();
			commentWidgets = room.getCommentWidgets();
			
			
			for(WidgetSprite ws : foregroundWidgets) {
				ws.resetFrameToZero();
			}
			for(WidgetSprite ws : backgroundWidgets) {
				ws.resetFrameToZero();
			}
			for(WidgetSprite ws : commentWidgets) {
				ws.resetFrameToZero();
			}
			
			goalSprite = room.getGoal();
			
			radios = room.getRadios();
			
			hurtzones = room.getHurtzones();
			
			
			lastRoomLoaded = null;
			isLoading = false;
		} catch(Throwable t) {
			String traceRaw = formatStackTrace(t);
			
			traceRaw = traceRaw.replace("\n", "<br>");
			JOptionPane.showMessageDialog(null, "<html>An error occurred in loadRoom:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
			
			System.exit(1);
			
		}
	}
	
	public void fireEnemyBullet(int xStart, int yStart, char direction) {
		if(enemyBullets.size() > MAX_ENEMY_BULLETS) {
			return;
		}
		BulletSprite newBullet = new BulletSprite(false, -1, direction, xStart, yStart, bulletImageManager, this);
		enemyBullets.add(newBullet);
	}
	
	
	public void useDoor(DoorSprite door) {
		
		
		roomToBeLoaded = door.getDestinationRoom();
		roomToBeLoadedPlayerX = door.getDestinationPlayerSpawnX();
		roomToBeLoadedPlayerY = door.getDestinationPlayerSpawnY();
		
		
		
		if(roomToBeLoaded == null) {
			
			
			roomIsntEvenLoaded = true;
			
			while(door.getDestinationRoom() == null) {
				
//				this.gameDraw();
//				
//
//				
//				this.repaint();
				
				
				
				
				try {
					Thread.sleep(100L);
				} catch(Exception e) {
//					e.printStackTrace();
					break;
				}
				
				
			}
			
			roomIsntEvenLoaded = false;
			roomToBeLoaded = door.getDestinationRoom();
			
		}
		
		
		
		
		doorSegueTicks = SEGUE_FRAMES;
		doorUnfadeTicks = 0;
		if(stopFrame == null) {
			stopFrame = createImage(PLAY_AREA_WIDTH, PANEL_HEIGHT);
			Graphics g = stopFrame.getGraphics();
			g.drawImage(canvasBuffer, 0,0, PLAY_AREA_WIDTH, PANEL_HEIGHT,  0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT,  null);
		}
			
//		loadRoom(door.getDestinationRoom(), door.getDestinationPlayerSpawnX(), door.getDestinationPlayerSpawnY(), false);
		
		
	}
	
	public void respawn() {
		
		
		
		
		loadRoom(this.playerRespawnRoom, this.playerRespawnX, this.playerRespawnY, true);
		player.healAllToMax();
		
	}
	
	public void playerDied() {
		
//		System.out.println("<><>DELME " + formatStackTrace(Thread.currentThread().getStackTrace()));
		
		deathSegueTicks = SEGUE_FRAMES;

		if(stopFrame == null) {
			stopFrame = createImage(PLAY_AREA_WIDTH, PANEL_HEIGHT);
			Graphics g = stopFrame.getGraphics();
			g.drawImage(canvasBuffer, 0,0, PLAY_AREA_WIDTH, PANEL_HEIGHT,  0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT,  null);
		}
	}
	
	public void addEnemy(EnemySprite enemy) {
		enemies.add(enemy);
	}
	
	public void goToMenuResumeNotAllowed() {
		isPaused = true;
		canResume = false;
//		commentaryIsNotLocked = false;
		menuPosition = MENU_POSITION_NEW;
	}
	
	public void goToMenuResumeNotAllowedCommentaryAllowed() {
		isPaused = true;
		canResume = false;
		commentaryIsNotLocked = true;
		menuPosition = MENU_POSITION_OPTIONS;
	}
	
	public RainSprite getRain() {
		return rain;
	}
	
	public void setShowingEndingCutscene(boolean should) {
		isShowingEndingCutscene = should;
	}
	
	public boolean isShowingEndingCutscene() {
		return isShowingEndingCutscene;
	}
	
	
//	public void writeOutForeground() {
//		
//		try {
//			ImageIO.write(currentForeground.getForeground(), "GIF", new File("C:\\WFMeltdown\\roomOut.GIF"));
//			ImageIO.write(canvasBuffer, "GIF", new File("C:\\WFMeltdown\\roomOut2.GIF"));
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
////			e.printStackTrace();
//		}
//		
//		
//	}
	
	public BackgroundMusic getBGM() {
		return bgm;
	}
	
	
	
	public void loadLevelFromDialog() {
		
		//System.out.println("now in loadLevelFromDialog!");
		
		
		FileDialog fd = new FileDialog((JFrame)enclosing);
		
		fd.setMode(FileDialog.LOAD);
		
		fd.setModal(true);
		
		fd.setVisible(true);
		
		String fileName = fd.getFile();
		String dir = fd.getDirectory();
		
		if(fileName == null || dir == null) {
			isSelectingNew = false;
			isShowingSaveExitMenu = false;
			isConfirmingNew = false;
			isConfirmingNewTutorial = false;
			isConfirmingLoad = false;
			menuPosition = MENU_POSITION_NEW;
			return;
		}
		
		
		if(!LevelData.checkLevelStartingPointDisplayDialogIfNot(dir + fileName))
			return;
		
		try {
			isLoading = true;
			roomIsntEvenLoaded = true;
			LevelData candidate = new LevelData(dir + fileName, this, true);
			loadLevel = candidate;
		} catch(Exception e) {
			JOptionPane.showMessageDialog(this, "Unable to load the given file: " + fileName,"Error occurred", JOptionPane.ERROR_MESSAGE);
			isSelectingNew = false;
			isShowingSaveExitMenu = false;
			isConfirmingNew = false;
			isConfirmingNewTutorial = false;
			isConfirmingLoad = false;
			menuPosition = MENU_POSITION_NEW;
			loadLevel = null;
			
			//System.err.println("Here is the stack trace:");
			//e.printStackTrace();
			
			return;
		} finally {
			isLoading = false;
			roomIsntEvenLoaded = false;
		}
		
		
		//System.out.println("<><>DELME let's get a");
		this.canResume = true;
		this.isShowingEndingCutscene = false;
		this.player.endCutsceneMode();
		
	}
	
	
	public void update(Graphics g) {
		paintComponent(g);
	}
	
	public void drawLoading(Graphics g) {

		canvasBuffer.flush();
		
//		System.out.println("<><>DELME now in drawLoading...");
		
		Color origCol = g.getColor();
		
		g.setColor(new Color(128, 0, 200));
		
		
		g.fillRect(0, 0, PLAY_AREA_WIDTH, PANEL_HEIGHT);
		
		loadingFrame++;
		if(loadingFrame >= loadingAnimation.length)
			loadingFrame = 0;
		
//		System.out.println("<><>DELME about to draw the loading animation...loadingFrame? " + loadingFrame + ", roomIsntEvenLoaded? " + roomIsntEvenLoaded);
		
		loadingAnimation[loadingFrame].drawObject(g, PLAY_AREA_WIDTH / 2, PANEL_HEIGHT / 2);
		
		g.setColor(new Color(255, 200, 200));
		try {
			if(roomIsntEvenLoaded) {
				g.drawString("still loading game details from file...", PLAY_AREA_WIDTH / 2 - 40, PANEL_HEIGHT / 2 + 75);
			} else if(loadProgress == Double.NaN) {
				g.drawString("***", PLAY_AREA_WIDTH / 2 - 40, PANEL_HEIGHT / 2 + 75);
			} else {
				g.drawString(Integer.toString((int) (loadProgress * 100)) + "%", PLAY_AREA_WIDTH / 2 - 40, PANEL_HEIGHT / 2 + 75); 
			}
		} catch(Exception e) {
			String name = PonyPanel.formatStackTrace(e);
			JOptionPane.showMessageDialog(null, "Exception detected, will ignore:  " + name );
		}
		
		
		try {
			Thread.sleep(100L);
		} catch(Exception e) {}
		
		g.setColor(origCol);
		
	}
	
	
	public RoomData getRespawnRoom() {
		return playerRespawnRoom;
	}
	
	
	public void toggleMusic() {
		
		musicSwitchedOn = !musicSwitchedOn;
		
		if(musicSwitchedOn) {
			bgm.pause();
		} else {
			bgm.start();
		}
		
	}
	
	public void radioCompleted() {
		
		if(!musicSwitchedOn)
			return;
		
		bgm.start();
		
	}
	
	public void radioBeginning() {
		
		if(!musicSwitchedOn)
			return;
		
		bgm.pause();
		
	}
	
	public void setShowingCommentaryUnlocked() {
		isShowingCommentaryUnlocked = true;
	}
	
	
	private boolean radioIsRunning() {
		
		if(radios != null) {
			for(RadioSprite radio : radios) {
				if(radio.isPlaying())
					return true;
			}
		}
		
		return false;
		
		
	}
	
	private void writeSaveFile() {
		
		
		FileDialog fd = new FileDialog((JFrame)enclosing);
		
		fd.setMode(FileDialog.SAVE);
		
		fd.setModal(true);
		
		fd.setVisible(true);
		
		String fileName = fd.getFile();
		String dir = fd.getDirectory();
		
		if(dir == null || fileName == null) {
			return;
		}
		
		try {
			
			String levelName = null;
			boolean fromFiles = false;
			
			if(currentRoom != null) {
				LevelData currentLevel = currentRoom.getParent();
				if(currentLevel != null) {
					levelName = currentLevel.getFileName();
					fromFiles = currentLevel.isFromFiles();
				} else {
					JOptionPane.showMessageDialog(null, "Unable to create save file; currentLevel was null!","Error", JOptionPane.WARNING_MESSAGE);
					return;
				}
			} else {
				JOptionPane.showMessageDialog(null, "Unable to create save file; currentRoom was null!","Error", JOptionPane.WARNING_MESSAGE);
				return;
			}
			
			BufferedWriter out = new BufferedWriter(new FileWriter(dir + fileName));
			
			if(!fromFiles) {
				out.write("*");
			}
			
			out.write(levelName);
			out.newLine();
			out.write(playerRespawnRoom.getRoomName());
			out.newLine();
			out.write(Integer.toString(playerRespawnX));
			out.newLine();
			out.write(Integer.toString(playerRespawnY));
			out.newLine();
			if(roomWhereBossWasKilled == null 
					|| !playerRespawnRoom.getRoomName().equalsIgnoreCase(roomWhereBossWasKilled)) {
				out.write("spawn");
			} else {
				out.write("nospawn");
			}
			out.newLine();
			if(commentaryIsNotLocked)
				out.write("commentary");
			else
				out.write("no");
			
			
			out.close();
			
			
		} catch(Exception e) {
			
			String traceRaw = formatStackTrace(e);
			
			traceRaw = traceRaw.replace("\n", "<br>");
			JOptionPane.showMessageDialog(null, "<html>Unable to write save file; error details:<br><br>"+traceRaw+"</html>","Error",JOptionPane.WARNING_MESSAGE);
			
			
		}
		
		
		
	}
	
	
	
	private void restoreGame() {
		
		
		FileDialog fd = new FileDialog((JFrame)enclosing);
		
		fd.setMode(FileDialog.LOAD);
		
		fd.setModal(true);
		
		fd.setVisible(true);
		
		String fileName = fd.getFile();
		String dir = fd.getDirectory();	
		
		
		if(dir == null || fileName == null)
			return;
		
		player.healAllToMax();
		
		try {
			
			BufferedReader in = new BufferedReader(new FileReader(dir + fileName));
			
			String toBeLoaded = in.readLine();
			String roomName = in.readLine();
			String xSpawnStr = in.readLine();
			String ySpawnStr = in.readLine();
			String bossSpawn = in.readLine();
			String commentary = in.readLine();
			
			in.close();
			
			
			if(commentary != null && commentary.equals("commentary")) {
				commentaryIsNotLocked = true;
			}
			
			if(toBeLoaded.contains("*")) {
				
				if(toBeLoaded.contains("tutorial")) {
					
//					System.out.println("<><>DELME about to load up tutorial...");
					
					
					if(bossSpawn.trim().equalsIgnoreCase("nospawn")) {
						roomWhereBossWasKilled = roomName;
					} else {
						roomWhereBossWasKilled = null;
					}
					
					if(tutorialLevel.getRoom(roomName) == null) {
						roomIsntEvenLoaded = true;
						isPaused = false;
						
						while(tutorialLevel.getRoom(roomName) == null) {
							
//							System.out.println("<><>DELME it should've drawn the loading bit...");
							
//							this.gameDraw();
//							
//
//							
//							
//							this.paintImmediately(0, 0, 800, 600);//repaint();
							
							try {
								Thread.sleep(100L);
							} catch(Exception e) {
								break;
							}
							
						}
						
						
						roomIsntEvenLoaded = false;
						isPaused = true;
					}
					
					tutorialLevel.resetAllGoals();
					
					loadRoom(tutorialLevel.getRoom(roomName), Integer.parseInt(xSpawnStr.trim()), Integer.parseInt(ySpawnStr.trim()), true);
					
//					System.out.println("<><>DELME calling loadingLevel(" + tutorialLevel.shouldHaveRain() + ")...");
					player.loadingLevel(tutorialLevel.shouldHaveRain());
					player.endCutsceneMode();
					canResume = true;
					
					isPaused = false;
					isShowingSaveExitMenu = false;
					isConfirmingLoad = false;
					isConfirmingNew = false;
					isConfirmingNewTutorial = false;
					isShowingEndingCutscene = false;
					stopFrame = null;
					doorSegueTicks = 0;
					deathSegueTicks = 0;
					doorUnfadeTicks = 0;
					rain = new RainSprite(new Color(50, 100, 200));
					
					playerRespawnRoom = tutorialLevel.getRoom(roomName);
					playerRespawnX = Integer.parseInt(xSpawnStr.trim());
					playerRespawnY = Integer.parseInt(ySpawnStr.trim());
					
					BackgroundMusic newBgm = mainLevel.getBgm();
//					if(this.bgm != null && this.bgm != newBgm) {
						this.bgm.pause();
						this.bgm.dispose();
//					}
					this.bgm = newBgm;
					if(this.bgm != null && musicSwitchedOn) {
						this.bgm.startFromBeginning();
					}
					
					
					
				} else if(toBeLoaded.contains("weather")) {

					if(bossSpawn.trim().equalsIgnoreCase("nospawn")) {
						roomWhereBossWasKilled = roomName;
					} else {
						roomWhereBossWasKilled = null;
					}
					
//					JOptionPane.showMessageDialog(null, "<><>DELME mainLevel.getRoom(roomName) is null?  " + (mainLevel.getRoom(roomName) == null) + "...for that matter, roomName: <<" + roomName + ">>");
					
					if(mainLevel.getRoom(roomName) == null) {
						roomIsntEvenLoaded = true;
						isPaused = false;
						while(mainLevel.getRoom(roomName) == null) {
							
//							System.out.println("<><>DELME it should've drawn the loading bit 2...");
							
//							this.gameDraw();
//							
//
//							
//							this.paintImmediately(0, 0, 800, 600);
//							repaint();
							
							
							try {
								Thread.sleep(100L);
							} catch(Exception e) {
								break;
							}
							
						}
						
						
						roomIsntEvenLoaded = false;
						isPaused = true;
					}
					
					mainLevel.resetAllGoals();
					
					loadRoom(mainLevel.getRoom(roomName), Integer.parseInt(xSpawnStr.trim()), Integer.parseInt(ySpawnStr.trim()), true);
					
					player.loadingLevel(mainLevel.shouldHaveRain());
					
					player.endCutsceneMode();
					canResume = true;
					
					isPaused = false;
					isShowingSaveExitMenu = false;
					isConfirmingLoad = false;
					isConfirmingNew = false;
					isConfirmingNewTutorial = false;
					isShowingEndingCutscene = false;
					stopFrame = null;
					doorSegueTicks = 0;
					deathSegueTicks = 0;
					doorUnfadeTicks = 0;
					rain = new RainSprite(new Color(50, 100, 200));
					
					playerRespawnRoom = mainLevel.getRoom(roomName);
					playerRespawnX = Integer.parseInt(xSpawnStr.trim());
					playerRespawnY = Integer.parseInt(ySpawnStr.trim());
					
					BackgroundMusic newBgm = mainLevel.getBgm();
//					if(this.bgm != null && this.bgm != newBgm) {
						this.bgm.pause();
						this.bgm.dispose();
//					}
					this.bgm = newBgm;
					if(this.bgm != null && musicSwitchedOn) {
						this.bgm.startFromBeginning();
					}
					
					
				}
				
			} else {
				
				if(loadLevel != null && loadLevel.getFileName() != null && loadLevel.getFileName().equals(toBeLoaded)) {
					//we don't need to load a new level!
					
					loadLevel.resetAllGoals();
					
					if(bossSpawn.trim().equalsIgnoreCase("nospawn")) {
						roomWhereBossWasKilled = roomName;
					} else {
						roomWhereBossWasKilled = null;
					}
					
					loadRoom(loadLevel.getRoom(roomName), Integer.parseInt(xSpawnStr.trim()), Integer.parseInt(ySpawnStr.trim()), true);
					
					player.loadingLevel(loadLevel.shouldHaveRain());
					
					player.endCutsceneMode();
					canResume = true;
					
					isPaused = false;
					isShowingSaveExitMenu = false;
					isConfirmingLoad = false;
					isConfirmingNew = false;
					isConfirmingNewTutorial = false;
					isShowingEndingCutscene = false;
					stopFrame = null;
					doorSegueTicks = 0;
					deathSegueTicks = 0;
					doorUnfadeTicks = 0;
					if(loadLevel.shouldHaveRain()) {
						rain = new RainSprite(new Color(50, 100, 200));
					} else {
						rain = null;
					}
					
					playerRespawnRoom = loadLevel.getRoom(roomName);
					playerRespawnX = Integer.parseInt(xSpawnStr.trim());
					playerRespawnY = Integer.parseInt(ySpawnStr.trim());
					
					BackgroundMusic newBgm = loadLevel.getBgm();
//					if(this.bgm != null && this.bgm != newBgm) {
						this.bgm.pause();
						this.bgm.dispose();
//					}
					this.bgm = newBgm;
					if(this.bgm != null && musicSwitchedOn) {
						this.bgm.startFromBeginning();
					}
					
					
				} else {
					
					
					
					try {
						
						isLoading = true;
						roomIsntEvenLoaded = true;
						
						LevelData candidate = new LevelData(toBeLoaded.trim(), this, true);
						loadLevel = candidate;
						
						roomIsntEvenLoaded = false;
						isLoading = false;
						
//						JOptionPane.showMessageDialog(null, "<><>DELME roomName: <<" + roomName + ">>, is it null? " + (loadLevel.getRoom(roomName) == null));
						
//						loadLevel.soundOffAllRooms();

						if(bossSpawn.trim().equalsIgnoreCase("nospawn")) {
							roomWhereBossWasKilled = roomName;
						} else {
							roomWhereBossWasKilled = null;
						}
						
						loadRoom(loadLevel.getRoom(roomName), Integer.parseInt(xSpawnStr.trim()), Integer.parseInt(ySpawnStr.trim()), true);

						player.loadingLevel(loadLevel.shouldHaveRain());
						
						player.endCutsceneMode();
						canResume = true;
						
						isPaused = false;
						isShowingSaveExitMenu = false;
						isConfirmingLoad = false;
						isConfirmingNew = false;
						isConfirmingNewTutorial = false;
						isShowingEndingCutscene = false;
						stopFrame = null;
						doorSegueTicks = 0;
						deathSegueTicks = 0;
						doorUnfadeTicks = 0;
						if(loadLevel.shouldHaveRain()) {
							rain = new RainSprite(new Color(50, 100, 200));
						} else {
							rain = null;
						}
						
						playerRespawnRoom = loadLevel.getRoom(roomName);
						playerRespawnX = Integer.parseInt(xSpawnStr.trim());
						playerRespawnY = Integer.parseInt(ySpawnStr.trim());
						
						BackgroundMusic newBgm = loadLevel.getBgm();
//						if(this.bgm != null && this.bgm != newBgm) {
							this.bgm.pause();
							this.bgm.dispose();
//						}
						this.bgm = newBgm;
						if(this.bgm != null && musicSwitchedOn) {
							this.bgm.startFromBeginning();
						}
						
					} catch(Exception e) {
						JOptionPane.showMessageDialog(this, "Unable to load the given file: " + fileName,"Error occurred", JOptionPane.ERROR_MESSAGE);
						isSelectingNew = false;
						isShowingSaveExitMenu = false;
						isConfirmingNew = false;
						isConfirmingNewTutorial = false;
						isConfirmingLoad = false;
						menuPosition = MENU_POSITION_NEW;
						loadLevel = null;
						
						//System.err.println("Here is the stack trace:");
						//e.printStackTrace();
						
						return;
					}
				}
			}
			
			
		} catch(Exception e) {
			String traceRaw = formatStackTrace(e);
			
			traceRaw = traceRaw.replace("\n", "<br>");
			JOptionPane.showMessageDialog(null, "<html>An error occurred while trying to restore the game:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
			
			System.exit(1);
		}
		
		
	}
	
	public PlayerSprite getPlayerSprite() {
		return player;
	}
	
	
	public void openWantToHelpScreen() {
		
		
		int response = JOptionPane.showConfirmDialog(this, "<html>I'm trying to turn this into a collaboration,<br>but so far, the response has been...underwhelming...<br><br>I have a thread on MLPForums.com for the collab;<br>want to open a browser to this?<br><br>You'll need to create an MLPForums account if you don't<br>already have one in order to post.</html>", "Want to collaborate?", JOptionPane.YES_NO_OPTION);
		
		if(response == JOptionPane.NO_OPTION)
			return;
		
		if(!Desktop.isDesktopSupported()) {
			
			JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there's no feature for opening browser windows from Java programs.<br>" +
					"You'll need to open one yourself and go to http://mlpforums.com/topic/114399-seeking-help-for-an-epic-fangame-collaboration/</html>");
			
		} else {
			Desktop desktop = Desktop.getDesktop();
	        if (desktop.isSupported(Desktop.Action.BROWSE)) {
	        	try {
	        		desktop.browse(new URI("http://mlpforums.com/topic/114399-seeking-help-for-an-epic-fangame-collaboration/"));
	        	} catch(Exception e) {
	        		JOptionPane.showMessageDialog(null, PonyPanel.formatStackTrace(e),"Error while trying to navigate to web page", JOptionPane.ERROR_MESSAGE);
	        	}
	        } else {
	        	JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there isn't a feature for opening browser windows from Java programs.<br>" +
						"You'll need to open one yourself and go to http://mlpforums.com/topic/114399-seeking-help-for-an-epic-fangame-collaboration/</html>");
	        }
		}
		
		
		
	}
	
	
	public void openLeaveFeedbackScreen() {
		
		
		int response = JOptionPane.showConfirmDialog(this, "<html>I have a thread discussing this game on MLPForums.com where I'm collecting feedback;<br>want to open a browser to this?<br><br>You'll need to create an MLPForums account if you don't<br>already have one in order to post.</html>", "Want to leave feedback?", JOptionPane.YES_NO_OPTION);
		
		if(response == JOptionPane.NO_OPTION)
			return;
		
		if(!Desktop.isDesktopSupported()) {
			
			JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there's no feature for opening browser windows from Java programs.<br>" +
					"You'll need to open one yourself and go to http://mlpforums.com/topic/114199-fangame-weather-factory-meltdown/</html>");
			
		} else {
			Desktop desktop = Desktop.getDesktop();
	        if (desktop.isSupported(Desktop.Action.BROWSE)) {
	        	try {
	        		desktop.browse(new URI("http://mlpforums.com/topic/114199-fangame-weather-factory-meltdown/"));
	        	} catch(Exception e) {
	        		JOptionPane.showMessageDialog(null, PonyPanel.formatStackTrace(e),"Error while trying to navigate to web page", JOptionPane.ERROR_MESSAGE);
	        	}
	        } else {
	        	JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there isn't a feature for opening browser windows from Java programs.<br>" +
						"You'll need to open one yourself and go to http://mlpforums.com/topic/114199-fangame-weather-factory-meltdown/</html>");
	        }
		}
		
		
		
	}
	
}
